/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.pubchemxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.xmlpull.v1.XmlPullParser;

public class PubChemXMLHelper {
    private IChemObjectBuilder builder;
    private IsotopeFactory factory;
    public static final String EL_PCCOMPOUND = "PC-Compound";
    public static final String EL_PCCOMPOUNDS = "PC-Compounds";
    public static final String EL_PCSUBSTANCE = "PC-Substance";
    public static final String EL_PCSUBSTANCE_SID = "PC-Substance_sid";
    public static final String EL_PCCOMPOUND_ID = "PC-Compound_id";
    public static final String EL_PCCOMPOUND_CID = "PC-CompoundType_id_cid";
    public static final String EL_PCID_ID = "PC-ID_id";
    public static final String EL_ATOMBLOCK = "PC-Atoms";
    public static final String EL_ATOMSELEMENT = "PC-Atoms_element";
    public static final String EL_ATOMSCHARGE = "PC-Atoms_charge";
    public static final String EL_ATOMINT = "PC-AtomInt";
    public static final String EL_ATOMINT_AID = "PC-AtomInt_aid";
    public static final String EL_ATOMINT_VALUE = "PC-AtomInt_value";
    public static final String EL_ELEMENT = "PC-Element";
    public static final String EL_COORDINATESBLOCK = "PC-Compound_coords";
    public static final String EL_COORDINATES_AID = "PC-Coordinates_aid";
    public static final String EL_COORDINATES_AIDE = "PC-Coordinates_aid_E";
    public static final String EL_ATOM_CONFORMER = "PC-Conformer";
    public static final String EL_ATOM_CONFORMER_X = "PC-Conformer_x";
    public static final String EL_ATOM_CONFORMER_XE = "PC-Conformer_x_E";
    public static final String EL_ATOM_CONFORMER_Y = "PC-Conformer_y";
    public static final String EL_ATOM_CONFORMER_YE = "PC-Conformer_y_E";
    public static final String EL_ATOM_CONFORMER_Z = "PC-Conformer_z";
    public static final String EL_ATOM_CONFORMER_ZE = "PC-Conformer_z_E";
    public static final String EL_BONDBLOCK = "PC-Bonds";
    public static final String EL_BONDID1 = "PC-Bonds_aid1";
    public static final String EL_BONDID2 = "PC-Bonds_aid2";
    public static final String EL_BONDORDER = "PC-Bonds_order";
    public static final String EL_PROPSBLOCK = "PC-Compound_props";
    public static final String EL_PROPS_INFODATA = "PC-InfoData";
    public static final String EL_PROPS_URNLABEL = "PC-Urn_label";
    public static final String EL_PROPS_URNNAME = "PC-Urn_name";
    public static final String EL_PROPS_SVAL = "PC-InfoData_value_sval";
    public static final String EL_PROPS_FVAL = "PC-InfoData_value_fval";
    public static final String EL_PROPS_BVAL = "PC-InfoData_value_binary";

    public PubChemXMLHelper(IChemObjectBuilder builder) throws IOException {
        this.builder = builder;
        this.factory = Isotopes.getInstance();
    }

    public IAtomContainerSet parseCompoundsBlock(XmlPullParser parser) throws Exception {
        IAtomContainerSet set = (IAtomContainerSet)this.builder.newInstance(IAtomContainerSet.class, new Object[0]);
        if (!parser.getName().equals(EL_PCCOMPOUNDS)) {
            return null;
        }
        while (parser.next() != 1) {
            IAtomContainer molecule;
            if (parser.getEventType() == 3) {
                if (!EL_PCCOMPOUNDS.equals(parser.getName())) continue;
                break;
            }
            if (parser.getEventType() != 2 || !EL_PCCOMPOUND.equals(parser.getName()) || (molecule = this.parseMolecule(parser, this.builder)).getAtomCount() <= 0) continue;
            set.addAtomContainer(molecule);
        }
        return set;
    }

    public IChemModel parseSubstance(XmlPullParser parser) throws Exception {
        IChemModel model = (IChemModel)this.builder.newInstance(IChemModel.class, new Object[0]);
        if (!parser.getName().equals(EL_PCSUBSTANCE)) {
            return null;
        }
        while (parser.next() != 1) {
            if (parser.getEventType() == 3) {
                if (!EL_PCSUBSTANCE.equals(parser.getName())) continue;
                break;
            }
            if (parser.getEventType() != 2) continue;
            if (EL_PCCOMPOUNDS.equals(parser.getName())) {
                IAtomContainerSet set = this.parseCompoundsBlock(parser);
                model.setMoleculeSet(set);
                continue;
            }
            if (!EL_PCSUBSTANCE_SID.equals(parser.getName())) continue;
            String sid = this.getSID(parser);
            model.setProperty((Object)"cdk:Title", (Object)sid);
        }
        return model;
    }

    public String getSID(XmlPullParser parser) throws Exception {
        String sid = "unknown";
        while (parser.next() != 1) {
            if (parser.getEventType() == 3) {
                if (!EL_PCSUBSTANCE_SID.equals(parser.getName())) continue;
                break;
            }
            if (parser.getEventType() != 2 || !EL_PCID_ID.equals(parser.getName())) continue;
            sid = parser.nextText();
        }
        return sid;
    }

    public String getCID(XmlPullParser parser) throws Exception {
        String cid = "unknown";
        while (parser.next() != 1) {
            if (parser.getEventType() == 3) {
                if (!EL_PCCOMPOUND_ID.equals(parser.getName())) continue;
                break;
            }
            if (parser.getEventType() != 2 || !EL_PCCOMPOUND_CID.equals(parser.getName())) continue;
            cid = parser.nextText();
        }
        return cid;
    }

    public void parseAtomElements(XmlPullParser parser, IAtomContainer molecule) throws Exception {
        while (parser.next() != 1) {
            IAtom atom;
            if (parser.getEventType() == 3) {
                if (!EL_ATOMSELEMENT.equals(parser.getName())) continue;
                break;
            }
            if (parser.getEventType() != 2 || !EL_ELEMENT.equals(parser.getName())) continue;
            int atomicNumber = Integer.parseInt(parser.nextText());
            IElement element = this.factory.getElement(atomicNumber);
            if (element == null) {
                atom = (IAtom)molecule.getBuilder().newInstance(IPseudoAtom.class, new Object[0]);
                molecule.addAtom(atom);
                continue;
            }
            atom = (IAtom)molecule.getBuilder().newInstance(IAtom.class, new Object[]{element.getSymbol()});
            atom.setAtomicNumber(element.getAtomicNumber());
            molecule.addAtom(atom);
        }
    }

    public void parserAtomBlock(XmlPullParser parser, IAtomContainer molecule) throws Exception {
        while (parser.next() != 1) {
            if (parser.getEventType() == 3) {
                if (!EL_ATOMBLOCK.equals(parser.getName())) continue;
                break;
            }
            if (parser.getEventType() != 2) continue;
            if (EL_ATOMSELEMENT.equals(parser.getName())) {
                this.parseAtomElements(parser, molecule);
                continue;
            }
            if (!EL_ATOMSCHARGE.equals(parser.getName())) continue;
            this.parseAtomCharges(parser, molecule);
        }
    }

    public void parserCompoundInfoData(XmlPullParser parser, IAtomContainer molecule) throws Exception {
        String urn_label = null;
        String urn_name = null;
        String sval = null;
        while (parser.next() != 1) {
            if (parser.getEventType() == 3) {
                if (!EL_PROPS_INFODATA.equals(parser.getName())) continue;
                break;
            }
            if (parser.getEventType() != 2) continue;
            if (EL_PROPS_URNNAME.equals(parser.getName())) {
                urn_name = parser.nextText();
                continue;
            }
            if (EL_PROPS_URNLABEL.equals(parser.getName())) {
                urn_label = parser.nextText();
                continue;
            }
            if (EL_PROPS_SVAL.equals(parser.getName())) {
                sval = parser.nextText();
                continue;
            }
            if (EL_PROPS_FVAL.equals(parser.getName())) {
                sval = parser.nextText();
                continue;
            }
            if (!EL_PROPS_BVAL.equals(parser.getName())) continue;
            sval = parser.nextText();
        }
        if (urn_label != null & sval != null) {
            String property = urn_label + (urn_name == null ? "" : " (" + urn_name + ")");
            molecule.setProperty((Object)property, sval);
        }
    }

    public void parseAtomCharges(XmlPullParser parser, IAtomContainer molecule) throws Exception {
        block0: while (parser.next() != 1) {
            if (parser.getEventType() == 3) {
                if (!EL_ATOMSCHARGE.equals(parser.getName())) continue;
                break;
            }
            if (parser.getEventType() != 2 || !EL_ATOMINT.equals(parser.getName())) continue;
            int aid = 0;
            int charge = 0;
            while (parser.next() != 1) {
                if (parser.getEventType() == 3) {
                    if (!EL_ATOMINT.equals(parser.getName())) continue;
                    molecule.getAtom(aid - 1).setFormalCharge(Integer.valueOf(charge));
                    continue block0;
                }
                if (parser.getEventType() != 2) continue;
                if (EL_ATOMINT_AID.equals(parser.getName())) {
                    aid = Integer.parseInt(parser.nextText());
                    continue;
                }
                if (!EL_ATOMINT_VALUE.equals(parser.getName())) continue;
                charge = Integer.parseInt(parser.nextText());
            }
        }
    }

    public IAtomContainer parseMolecule(XmlPullParser parser, IChemObjectBuilder builder) throws Exception {
        IAtomContainer molecule = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[0]);
        if (!parser.getName().equals(EL_PCCOMPOUND)) {
            return null;
        }
        while (parser.next() != 1) {
            if (parser.getEventType() == 3) {
                if (!EL_PCCOMPOUND.equals(parser.getName())) continue;
                break;
            }
            if (parser.getEventType() != 2) continue;
            if (EL_ATOMBLOCK.equals(parser.getName())) {
                this.parserAtomBlock(parser, molecule);
                continue;
            }
            if (EL_BONDBLOCK.equals(parser.getName())) {
                this.parserBondBlock(parser, molecule);
                continue;
            }
            if (EL_COORDINATESBLOCK.equals(parser.getName())) {
                this.parserCoordBlock(parser, molecule);
                continue;
            }
            if (EL_PROPS_INFODATA.equals(parser.getName())) {
                this.parserCompoundInfoData(parser, molecule);
                continue;
            }
            if (!EL_PCCOMPOUND_ID.equals(parser.getName())) continue;
            String cid = this.getCID(parser);
            molecule.setProperty((Object)"PubChem CID", (Object)cid);
        }
        return molecule;
    }

    public void parserBondBlock(XmlPullParser parser, IAtomContainer molecule) throws Exception {
        List<Object> id1s = new ArrayList();
        List<Object> id2s = new ArrayList();
        List<Object> orders = new ArrayList();
        while (parser.next() != 1) {
            if (parser.getEventType() == 3) {
                if (!EL_BONDBLOCK.equals(parser.getName())) continue;
                break;
            }
            if (parser.getEventType() != 2) continue;
            if (EL_BONDID1.equals(parser.getName())) {
                id1s = this.parseValues(parser, EL_BONDID1, "PC-Bonds_aid1_E");
                continue;
            }
            if (EL_BONDID2.equals(parser.getName())) {
                id2s = this.parseValues(parser, EL_BONDID2, "PC-Bonds_aid2_E");
                continue;
            }
            if (!EL_BONDORDER.equals(parser.getName())) continue;
            orders = this.parseValues(parser, EL_BONDORDER, "PC-BondType");
        }
        if (id1s.size() != id2s.size()) {
            throw new CDKException("Inequal number of atom identifier in bond block.");
        }
        if (id1s.size() != orders.size()) {
            throw new CDKException("Number of bond orders does not match number of bonds in bond block.");
        }
        for (int i = 0; i < id1s.size(); ++i) {
            IAtom atom1 = molecule.getAtom(Integer.parseInt((String)id1s.get(i)) - 1);
            IAtom atom2 = molecule.getAtom(Integer.parseInt((String)id2s.get(i)) - 1);
            IBond bond = (IBond)molecule.getBuilder().newInstance(IBond.class, new Object[]{atom1, atom2});
            int order = Integer.parseInt((String)orders.get(i));
            if (order == 1) {
                bond.setOrder(IBond.Order.SINGLE);
                molecule.addBond(bond);
            } else if (order == 2) {
                bond.setOrder(IBond.Order.DOUBLE);
                molecule.addBond(bond);
            }
            if (order != 3) continue;
            bond.setOrder(IBond.Order.TRIPLE);
            molecule.addBond(bond);
        }
    }

    public void parserCoordBlock(XmlPullParser parser, IAtomContainer molecule) throws Exception {
        List<Object> ids = new ArrayList();
        List<Object> xs = new ArrayList();
        List<Object> ys = new ArrayList();
        List<Object> zs = new ArrayList();
        boolean parsedFirstConformer = false;
        while (parser.next() != 1) {
            if (parser.getEventType() == 3) {
                if (EL_COORDINATESBLOCK.equals(parser.getName())) break;
                if (!EL_ATOM_CONFORMER.equals(parser.getName())) continue;
                parsedFirstConformer = true;
                continue;
            }
            if (parser.getEventType() != 2 || parsedFirstConformer) continue;
            if (EL_COORDINATES_AID.equals(parser.getName())) {
                ids = this.parseValues(parser, EL_COORDINATES_AID, EL_COORDINATES_AIDE);
                continue;
            }
            if (EL_ATOM_CONFORMER_X.equals(parser.getName())) {
                xs = this.parseValues(parser, EL_ATOM_CONFORMER_X, EL_ATOM_CONFORMER_XE);
                continue;
            }
            if (EL_ATOM_CONFORMER_Y.equals(parser.getName())) {
                ys = this.parseValues(parser, EL_ATOM_CONFORMER_Y, EL_ATOM_CONFORMER_YE);
                continue;
            }
            if (!EL_ATOM_CONFORMER_Z.equals(parser.getName())) continue;
            zs = this.parseValues(parser, EL_ATOM_CONFORMER_Z, EL_ATOM_CONFORMER_ZE);
        }
        boolean has2dCoords = ids.size() == xs.size() && ids.size() == ys.size();
        boolean has3dCoords = has2dCoords && ids.size() == zs.size();
        for (int i = 0; i < ids.size(); ++i) {
            Point2d coord;
            IAtom atom = molecule.getAtom(Integer.parseInt((String)ids.get(i)) - 1);
            if (has3dCoords) {
                coord = new Point3d(Double.parseDouble((String)xs.get(i)), Double.parseDouble((String)ys.get(i)), Double.parseDouble((String)zs.get(i)));
                atom.setPoint3d((Point3d)coord);
                continue;
            }
            if (!has2dCoords) continue;
            coord = new Point2d(Double.parseDouble((String)xs.get(i)), Double.parseDouble((String)ys.get(i)));
            atom.setPoint2d(coord);
        }
    }

    private List<String> parseValues(XmlPullParser parser, String endTag, String fieldTag) throws Exception {
        ArrayList<String> values = new ArrayList<String>();
        while (parser.next() != 1) {
            if (parser.getEventType() == 3) {
                if (!endTag.equals(parser.getName())) continue;
                break;
            }
            if (parser.getEventType() != 2 || !fieldTag.equals(parser.getName())) continue;
            String value = parser.nextText();
            values.add(value);
        }
        return values;
    }
}

