/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.rgraph;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.smsd.algorithm.matchers.DefaultBondMatcher;
import org.openscience.cdk.smsd.algorithm.matchers.DefaultMatcher;
import org.openscience.cdk.smsd.algorithm.matchers.DefaultRGraphAtomMatcher;
import org.openscience.cdk.smsd.algorithm.rgraph.CDKRGraph;
import org.openscience.cdk.smsd.algorithm.rgraph.CDKRMap;
import org.openscience.cdk.smsd.algorithm.rgraph.CDKRNode;
import org.openscience.cdk.smsd.global.TimeOut;
import org.openscience.cdk.smsd.tools.TimeManager;
import org.openscience.cdk.tools.manipulator.BondManipulator;

@Deprecated
public class CDKMCS {
    static final int ID1 = 0;
    static final int ID2 = 1;
    private static TimeManager timeManager = null;

    public static boolean isIsomorph(IAtomContainer sourceGraph, IAtomContainer targetGraph, boolean shouldMatchBonds) throws CDKException {
        if (sourceGraph instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        if (targetGraph.getAtomCount() != sourceGraph.getAtomCount()) {
            return false;
        }
        if (targetGraph.getAtomCount() == 1) {
            IAtom atom = sourceGraph.getAtom(0);
            IAtom atom2 = targetGraph.getAtom(0);
            if (atom instanceof IQueryAtom) {
                IQueryAtom qAtom = (IQueryAtom)atom;
                return qAtom.matches(targetGraph.getAtom(0));
            }
            if (atom2 instanceof IQueryAtom) {
                IQueryAtom qAtom = (IQueryAtom)atom2;
                return qAtom.matches(sourceGraph.getAtom(0));
            }
            String atomSymbol = atom2.getSymbol();
            return sourceGraph.getAtom(0).getSymbol().equals(atomSymbol);
        }
        return CDKMCS.getIsomorphMap(sourceGraph, targetGraph, shouldMatchBonds) != null;
    }

    public static List<CDKRMap> getIsomorphMap(IAtomContainer sourceGraph, IAtomContainer targetGraph, boolean shouldMatchBonds) throws CDKException {
        if (sourceGraph instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        List<CDKRMap> result = null;
        List<List<CDKRMap>> rMapsList = CDKMCS.search(sourceGraph, targetGraph, CDKMCS.getBitSet(sourceGraph), CDKMCS.getBitSet(targetGraph), false, false, shouldMatchBonds);
        if (!rMapsList.isEmpty()) {
            result = rMapsList.get(0);
        }
        return result;
    }

    public static List<CDKRMap> getIsomorphAtomsMap(IAtomContainer sourceGraph, IAtomContainer targetGraph, boolean shouldMatchBonds) throws CDKException {
        if (sourceGraph instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        List<CDKRMap> list = CDKMCS.checkSingleAtomCases(sourceGraph, targetGraph);
        if (list == null) {
            return CDKMCS.makeAtomsMapOfBondsMap(CDKMCS.getIsomorphMap(sourceGraph, targetGraph, shouldMatchBonds), sourceGraph, targetGraph);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public static List<List<CDKRMap>> getIsomorphMaps(IAtomContainer sourceGraph, IAtomContainer targetGraph, boolean shouldMatchBonds) throws CDKException {
        return CDKMCS.search(sourceGraph, targetGraph, CDKMCS.getBitSet(sourceGraph), CDKMCS.getBitSet(targetGraph), true, true, shouldMatchBonds);
    }

    public static List<List<CDKRMap>> getSubgraphMaps(IAtomContainer sourceGraph, IAtomContainer targetGraph, boolean shouldMatchBonds) throws CDKException {
        return CDKMCS.search(sourceGraph, targetGraph, new BitSet(), CDKMCS.getBitSet(targetGraph), true, true, shouldMatchBonds);
    }

    public static List<CDKRMap> getSubgraphMap(IAtomContainer sourceGraph, IAtomContainer targetGraph, boolean shouldMatchBonds) throws CDKException {
        List<CDKRMap> result = null;
        List<List<CDKRMap>> rMapsList = CDKMCS.search(sourceGraph, targetGraph, new BitSet(), CDKMCS.getBitSet(targetGraph), false, false, shouldMatchBonds);
        if (!rMapsList.isEmpty()) {
            result = rMapsList.get(0);
        }
        return result;
    }

    public static List<List<CDKRMap>> getSubgraphAtomsMaps(IAtomContainer sourceGraph, IAtomContainer targetGraph, boolean shouldMatchBonds) throws CDKException {
        List<CDKRMap> list = CDKMCS.checkSingleAtomCases(sourceGraph, targetGraph);
        if (list == null) {
            return CDKMCS.makeAtomsMapsOfBondsMaps(CDKMCS.getSubgraphMaps(sourceGraph, targetGraph, shouldMatchBonds), sourceGraph, targetGraph);
        }
        ArrayList<List<CDKRMap>> atomsMap = new ArrayList<List<CDKRMap>>();
        atomsMap.add(list);
        return atomsMap;
    }

    public static List<CDKRMap> getSubgraphAtomsMap(IAtomContainer sourceGraph, IAtomContainer targetGraph, boolean shouldMatchBonds) throws CDKException {
        List<CDKRMap> list = CDKMCS.checkSingleAtomCases(sourceGraph, targetGraph);
        if (list == null) {
            return CDKMCS.makeAtomsMapOfBondsMap(CDKMCS.getSubgraphMap(sourceGraph, targetGraph, shouldMatchBonds), sourceGraph, targetGraph);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public static boolean isSubgraph(IAtomContainer sourceGraph, IAtomContainer targetGraph, boolean shouldMatchBonds) throws CDKException {
        if (sourceGraph instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        if (targetGraph.getAtomCount() > sourceGraph.getAtomCount()) {
            return false;
        }
        if (targetGraph.getAtomCount() == 1) {
            IAtom atom = targetGraph.getAtom(0);
            for (int i = 0; i < sourceGraph.getAtomCount(); ++i) {
                IQueryAtom qAtom;
                IAtom atom2 = sourceGraph.getAtom(i);
                if (!(atom instanceof IQueryAtom ? (qAtom = (IQueryAtom)atom).matches(atom2) : (atom2 instanceof IQueryAtom ? (qAtom = (IQueryAtom)atom2).matches(atom) : atom2.getSymbol().equals(atom.getSymbol())))) continue;
                return true;
            }
            return false;
        }
        if (!CDKMCS.testSubgraphHeuristics(sourceGraph, targetGraph)) {
            return false;
        }
        return CDKMCS.getSubgraphMap(sourceGraph, targetGraph, shouldMatchBonds) != null;
    }

    public static List<IAtomContainer> getOverlaps(IAtomContainer sourceGraph, IAtomContainer targetGraph, boolean shouldMatchBonds) throws CDKException {
        List<List<CDKRMap>> rMapsList = CDKMCS.search(sourceGraph, targetGraph, new BitSet(), new BitSet(), true, false, shouldMatchBonds);
        ArrayList<IAtomContainer> graphList = CDKMCS.projectList(rMapsList, sourceGraph, 0);
        return CDKMCS.getMaximum(graphList, shouldMatchBonds);
    }

    public static BitSet getBitSet(IAtomContainer atomContainer) {
        BitSet bitSet;
        int size = atomContainer.getBondCount();
        if (size != 0) {
            bitSet = new BitSet(size);
            for (int i = 0; i < size; ++i) {
                bitSet.set(i);
            }
        } else {
            bitSet = new BitSet();
        }
        return bitSet;
    }

    public static CDKRGraph buildRGraph(IAtomContainer sourceGraph, IAtomContainer targetGraph, boolean shouldMatchBonds) throws CDKException {
        CDKRGraph rGraph = new CDKRGraph();
        CDKMCS.nodeConstructor(rGraph, sourceGraph, targetGraph, shouldMatchBonds);
        CDKMCS.arcConstructor(rGraph, sourceGraph, targetGraph);
        return rGraph;
    }

    public static List<List<CDKRMap>> search(IAtomContainer sourceGraph, IAtomContainer targetGraph, BitSet sourceBitSet, BitSet targetBitSet, boolean findAllStructure, boolean findAllMap, boolean shouldMatchBonds) throws CDKException {
        if (targetGraph.getAtomCount() == 1) {
            ArrayList<List<CDKRMap>> matches = new ArrayList<List<CDKRMap>>();
            IAtom queryAtom = targetGraph.getAtom(0);
            if (queryAtom instanceof IQueryAtom) {
                IQueryAtom qAtom = (IQueryAtom)queryAtom;
                for (IAtom atom : sourceGraph.atoms()) {
                    if (!qAtom.matches(atom)) continue;
                    ArrayList<CDKRMap> lmap = new ArrayList<CDKRMap>();
                    lmap.add(new CDKRMap(sourceGraph.indexOf(atom), 0));
                    matches.add(lmap);
                }
            } else {
                for (IAtom atom : sourceGraph.atoms()) {
                    if (!queryAtom.getSymbol().equals(atom.getSymbol())) continue;
                    ArrayList<CDKRMap> lmap = new ArrayList<CDKRMap>();
                    lmap.add(new CDKRMap(sourceGraph.indexOf(atom), 0));
                    matches.add(lmap);
                }
            }
            return matches;
        }
        ArrayList<List<CDKRMap>> rMapsList = new ArrayList<List<CDKRMap>>();
        CDKRGraph rGraph = CDKMCS.buildRGraph(sourceGraph, targetGraph, shouldMatchBonds);
        CDKMCS.setTimeManager(new TimeManager());
        rGraph.parse(sourceBitSet, targetBitSet, findAllStructure, findAllMap, CDKMCS.getTimeManager());
        List<BitSet> solutionList = rGraph.getSolutions();
        for (BitSet set : solutionList) {
            rMapsList.add(rGraph.bitSetToRMap(set));
        }
        return rMapsList;
    }

    public static IAtomContainer project(List<CDKRMap> rMapList, IAtomContainer graph, int key) {
        IAtomContainer atomContainer = graph.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        HashMap<IAtom, IAtom> table = new HashMap<IAtom, IAtom>();
        for (CDKRMap rMap : rMapList) {
            IAtom atom2;
            IBond bond = key == 0 ? graph.getBond(rMap.getId1()) : graph.getBond(rMap.getId2());
            IAtom atom = bond.getBegin();
            IAtom atom1 = (IAtom)table.get(atom);
            if (atom1 == null) {
                try {
                    atom1 = atom.clone();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                atomContainer.addAtom(atom1);
                table.put(atom, atom1);
            }
            if ((atom2 = (IAtom)table.get(atom = bond.getEnd())) == null) {
                try {
                    atom2 = atom.clone();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                atomContainer.addAtom(atom2);
                table.put(atom, atom2);
            }
            IBond newBond = graph.getBuilder().newInstance(IBond.class, new Object[]{atom1, atom2, bond.getOrder()});
            newBond.setFlag(32, bond.getFlag(32));
            atomContainer.addBond(newBond);
        }
        return atomContainer;
    }

    public static ArrayList<IAtomContainer> projectList(List<List<CDKRMap>> rMapsList, IAtomContainer graph, int key) {
        ArrayList<IAtomContainer> graphList = new ArrayList<IAtomContainer>();
        for (List<CDKRMap> rMapList : rMapsList) {
            IAtomContainer atomContainer = CDKMCS.project(rMapList, graph, key);
            graphList.add(atomContainer);
        }
        return graphList;
    }

    private static List<IAtomContainer> getMaximum(ArrayList<IAtomContainer> graphList, boolean shouldMatchBonds) throws CDKException {
        List reducedGraphList = (List)graphList.clone();
        for (int i = 0; i < graphList.size(); ++i) {
            IAtomContainer graphI = graphList.get(i);
            for (int j = i + 1; j < graphList.size(); ++j) {
                IAtomContainer graphJ = graphList.get(j);
                if (CDKMCS.isSubgraph(graphJ, graphI, shouldMatchBonds)) {
                    reducedGraphList.remove(graphI);
                    continue;
                }
                if (!CDKMCS.isSubgraph(graphI, graphJ, shouldMatchBonds)) continue;
                reducedGraphList.remove(graphJ);
            }
        }
        return reducedGraphList;
    }

    public static List<CDKRMap> checkSingleAtomCases(IAtomContainer sourceGraph, IAtomContainer targetGraph) throws CDKException {
        if (sourceGraph instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        if (targetGraph.getAtomCount() == 1) {
            ArrayList<CDKRMap> arrayList = new ArrayList<CDKRMap>();
            IAtom atom = targetGraph.getAtom(0);
            if (atom instanceof IQueryAtom) {
                IQueryAtom qAtom = (IQueryAtom)atom;
                for (int i = 0; i < sourceGraph.getAtomCount(); ++i) {
                    if (!qAtom.matches(sourceGraph.getAtom(i))) continue;
                    arrayList.add(new CDKRMap(i, 0));
                }
            } else {
                String atomSymbol = atom.getSymbol();
                for (int i = 0; i < sourceGraph.getAtomCount(); ++i) {
                    if (!sourceGraph.getAtom(i).getSymbol().equals(atomSymbol)) continue;
                    arrayList.add(new CDKRMap(i, 0));
                }
            }
            return arrayList;
        }
        if (sourceGraph.getAtomCount() == 1) {
            ArrayList<CDKRMap> arrayList = new ArrayList<CDKRMap>();
            IAtom atom = sourceGraph.getAtom(0);
            for (int i = 0; i < targetGraph.getAtomCount(); ++i) {
                IAtom atom2 = targetGraph.getAtom(i);
                if (atom2 instanceof IQueryAtom) {
                    IQueryAtom qAtom = (IQueryAtom)atom2;
                    if (!qAtom.matches(atom)) continue;
                    arrayList.add(new CDKRMap(0, i));
                    continue;
                }
                if (!atom2.getSymbol().equals(atom.getSymbol())) continue;
                arrayList.add(new CDKRMap(0, i));
            }
            return arrayList;
        }
        return null;
    }

    public static List<List<CDKRMap>> makeAtomsMapsOfBondsMaps(List<List<CDKRMap>> list, IAtomContainer sourceGraph, IAtomContainer targetGraph) {
        if (list == null) {
            return list;
        }
        if (targetGraph.getAtomCount() == 1) {
            return list;
        }
        ArrayList<List<CDKRMap>> result = new ArrayList<List<CDKRMap>>();
        for (List<CDKRMap> l2 : list) {
            result.add(CDKMCS.makeAtomsMapOfBondsMap(l2, sourceGraph, targetGraph));
        }
        return result;
    }

    public static List<CDKRMap> makeAtomsMapOfBondsMap(List<CDKRMap> list, IAtomContainer sourceGraph, IAtomContainer targetGraph) {
        if (list == null) {
            return list;
        }
        ArrayList<CDKRMap> result = new ArrayList<CDKRMap>();
        for (int i = 0; i < list.size(); ++i) {
            IBond bond1 = sourceGraph.getBond(list.get(i).getId1());
            IBond bond2 = targetGraph.getBond(list.get(i).getId2());
            IAtom[] atom1 = BondManipulator.getAtomArray(bond1);
            IAtom[] atom2 = BondManipulator.getAtomArray(bond2);
            for (int j = 0; j < 2; ++j) {
                List<IBond> bondsConnectedToAtom1j = sourceGraph.getConnectedBondsList(atom1[j]);
                for (int k = 0; k < bondsConnectedToAtom1j.size(); ++k) {
                    if (bondsConnectedToAtom1j.get(k).equals(bond1)) continue;
                    IBond testBond = bondsConnectedToAtom1j.get(k);
                    for (int m = 0; m < list.size(); ++m) {
                        if (list.get(m).getId1() != sourceGraph.indexOf(testBond)) continue;
                        IBond testBond2 = targetGraph.getBond(list.get(m).getId2());
                        for (int n = 0; n < 2; ++n) {
                            CDKRMap map2;
                            List<IBond> bondsToTest = targetGraph.getConnectedBondsList(atom2[n]);
                            if (!bondsToTest.contains(testBond2)) continue;
                            CDKRMap map = j == n ? new CDKRMap(sourceGraph.indexOf(atom1[0]), targetGraph.indexOf(atom2[0])) : new CDKRMap(sourceGraph.indexOf(atom1[1]), targetGraph.indexOf(atom2[0]));
                            if (!result.contains(map)) {
                                result.add(map);
                            }
                            if (result.contains(map2 = j == n ? new CDKRMap(sourceGraph.indexOf(atom1[1]), targetGraph.indexOf(atom2[1])) : new CDKRMap(sourceGraph.indexOf(atom1[0]), targetGraph.indexOf(atom2[1])))) continue;
                            result.add(map2);
                        }
                    }
                }
            }
        }
        return result;
    }

    private static void nodeConstructor(CDKRGraph graph, IAtomContainer ac1, IAtomContainer ac2, boolean shouldMatchBonds) throws CDKException {
        if (ac1 instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        graph.clear();
        for (int i = 0; i < ac1.getBondCount(); ++i) {
            IBond bondA1 = ac1.getBond(i);
            for (int j = 0; j < ac2.getBondCount(); ++j) {
                IBond bondA2 = ac2.getBond(j);
                if (bondA2 instanceof IQueryBond) {
                    IQueryBond queryBond = (IQueryBond)bondA2;
                    IQueryAtom atom1 = (IQueryAtom)bondA2.getBegin();
                    IQueryAtom atom2 = (IQueryAtom)bondA2.getEnd();
                    if (!queryBond.matches(bondA1) || (!atom1.matches(bondA1.getBegin()) || !atom2.matches(bondA1.getEnd())) && (!atom1.matches(bondA1.getEnd()) || !atom2.matches(bondA1.getBegin()))) continue;
                    graph.addNode(new CDKRNode(i, j));
                    continue;
                }
                if (!CDKMCS.isMatchFeasible(ac1, bondA1, ac2, bondA2, shouldMatchBonds)) continue;
                graph.addNode(new CDKRNode(i, j));
            }
        }
    }

    private static boolean isMatchFeasible(IAtomContainer ac1, IBond bondA1, IAtomContainer ac2, IBond bondA2, boolean shouldMatchBonds) {
        DefaultBondMatcher bondMatcher = new DefaultBondMatcher(ac1, bondA1, shouldMatchBonds);
        DefaultRGraphAtomMatcher atomMatcher1 = new DefaultRGraphAtomMatcher(ac1, bondA1.getBegin(), shouldMatchBonds);
        DefaultRGraphAtomMatcher atomMatcher2 = new DefaultRGraphAtomMatcher(ac1, bondA1.getEnd(), shouldMatchBonds);
        return DefaultMatcher.isBondMatch(bondMatcher, ac2, bondA2, shouldMatchBonds) && DefaultMatcher.isAtomMatch(atomMatcher1, atomMatcher2, ac2, bondA2, shouldMatchBonds);
    }

    private static void arcConstructor(CDKRGraph graph, IAtomContainer ac1, IAtomContainer ac2) throws CDKException {
        for (int i = 0; i < graph.getGraph().size(); ++i) {
            CDKRNode rNodeX = graph.getGraph().get(i);
            rNodeX.getForbidden().set(i);
        }
        graph.setFirstGraphSize(ac1.getBondCount());
        graph.setSecondGraphSize(ac2.getBondCount());
        for (int i = 0; i < graph.getGraph().size(); ++i) {
            CDKRNode rNodeX = graph.getGraph().get(i);
            for (int j = i + 1; j < graph.getGraph().size(); ++j) {
                CDKRNode rNodeY = graph.getGraph().get(j);
                IBond bondA1 = ac1.getBond(graph.getGraph().get(i).getRMap().getId1());
                IBond bondA2 = ac2.getBond(graph.getGraph().get(i).getRMap().getId2());
                IBond bondB1 = ac1.getBond(graph.getGraph().get(j).getRMap().getId1());
                IBond bondB2 = ac2.getBond(graph.getGraph().get(j).getRMap().getId2());
                if (bondA2 instanceof IQueryBond) {
                    if (bondA1.equals(bondB1) || bondA2.equals(bondB2) || !CDKMCS.queryAdjacencyAndOrder(bondA1, bondB1, bondA2, bondB2)) {
                        rNodeX.getForbidden().set(j);
                        rNodeY.getForbidden().set(i);
                        continue;
                    }
                    if (!CDKMCS.hasCommonAtom(bondA1, bondB1)) continue;
                    rNodeX.getExtension().set(j);
                    rNodeY.getExtension().set(i);
                    continue;
                }
                if (bondA1.equals(bondB1) || bondA2.equals(bondB2) || !CDKMCS.getCommonSymbol(bondA1, bondB1).equals(CDKMCS.getCommonSymbol(bondA2, bondB2))) {
                    rNodeX.getForbidden().set(j);
                    rNodeY.getForbidden().set(i);
                    continue;
                }
                if (!CDKMCS.hasCommonAtom(bondA1, bondB1)) continue;
                rNodeX.getExtension().set(j);
                rNodeY.getExtension().set(i);
            }
        }
    }

    private static boolean hasCommonAtom(IBond bondA, IBond bondB) {
        return bondA.contains(bondB.getBegin()) || bondA.contains(bondB.getEnd());
    }

    private static String getCommonSymbol(IBond bondA, IBond bondB) {
        String symbol = "";
        if (bondA.contains(bondB.getBegin())) {
            symbol = bondB.getBegin().getSymbol();
        } else if (bondA.contains(bondB.getEnd())) {
            symbol = bondB.getEnd().getSymbol();
        }
        return symbol;
    }

    private static boolean queryAdjacency(IBond bondA1, IBond bondB1, IBond bondA2, IBond bondB2) {
        IAtom atom1 = null;
        IAtom atom2 = null;
        if (bondA1.contains(bondB1.getBegin())) {
            atom1 = bondB1.getBegin();
        } else if (bondA1.contains(bondB1.getEnd())) {
            atom1 = bondB1.getEnd();
        }
        if (bondA2.contains(bondB2.getBegin())) {
            atom2 = bondB2.getBegin();
        } else if (bondA2.contains(bondB2.getEnd())) {
            atom2 = bondB2.getEnd();
        }
        if (atom1 != null && atom2 != null) {
            return ((IQueryAtom)atom2).matches(atom1);
        }
        return atom1 == null && atom2 == null;
    }

    private static boolean queryAdjacencyAndOrder(IBond bond1, IBond bond2, IBond queryBond1, IBond queryBond2) {
        IAtom centralAtom = null;
        IAtom centralQueryAtom = null;
        if (bond1.contains(bond2.getBegin())) {
            centralAtom = bond2.getBegin();
        } else if (bond1.contains(bond2.getEnd())) {
            centralAtom = bond2.getEnd();
        }
        if (queryBond1.contains(queryBond2.getBegin())) {
            centralQueryAtom = queryBond2.getBegin();
        } else if (queryBond1.contains(queryBond2.getEnd())) {
            centralQueryAtom = queryBond2.getEnd();
        }
        if (centralAtom != null && centralQueryAtom != null && ((IQueryAtom)centralQueryAtom).matches(centralAtom)) {
            IQueryAtom queryAtom1 = (IQueryAtom)queryBond1.getOther(centralQueryAtom);
            IQueryAtom queryAtom2 = (IQueryAtom)queryBond2.getOther(centralQueryAtom);
            IAtom atom1 = bond1.getOther(centralAtom);
            IAtom atom2 = bond2.getOther(centralAtom);
            return queryAtom1.matches(atom1) && queryAtom2.matches(atom2) || queryAtom1.matches(atom2) && queryAtom2.matches(atom1);
        }
        return centralAtom == null && centralQueryAtom == null;
    }

    private static boolean testSubgraphHeuristics(IAtomContainer ac1, IAtomContainer ac2) throws CDKException {
        IAtom atom;
        IBond bond;
        int i;
        if (ac1 instanceof IQueryAtomContainer) {
            throw new CDKException("The first IAtomContainer must not be an IQueryAtomContainer");
        }
        int ac1SingleBondCount = 0;
        int ac1DoubleBondCount = 0;
        int ac1TripleBondCount = 0;
        int ac1AromaticBondCount = 0;
        int ac2SingleBondCount = 0;
        int ac2DoubleBondCount = 0;
        int ac2TripleBondCount = 0;
        int ac2AromaticBondCount = 0;
        int ac1SCount = 0;
        int ac1OCount = 0;
        int ac1NCount = 0;
        int ac1FCount = 0;
        int ac1ClCount = 0;
        int ac1BrCount = 0;
        int ac1ICount = 0;
        int ac1CCount = 0;
        int ac2SCount = 0;
        int ac2OCount = 0;
        int ac2NCount = 0;
        int ac2FCount = 0;
        int ac2ClCount = 0;
        int ac2BrCount = 0;
        int ac2ICount = 0;
        int ac2CCount = 0;
        for (i = 0; i < ac1.getBondCount(); ++i) {
            bond = ac1.getBond(i);
            if (bond.getFlag(32)) {
                ++ac1AromaticBondCount;
                continue;
            }
            if (bond.getOrder() == IBond.Order.SINGLE) {
                ++ac1SingleBondCount;
                continue;
            }
            if (bond.getOrder() == IBond.Order.DOUBLE) {
                ++ac1DoubleBondCount;
                continue;
            }
            if (bond.getOrder() != IBond.Order.TRIPLE) continue;
            ++ac1TripleBondCount;
        }
        for (i = 0; i < ac2.getBondCount(); ++i) {
            bond = ac2.getBond(i);
            if (bond instanceof IQueryBond) continue;
            if (bond.getFlag(32)) {
                ++ac2AromaticBondCount;
                continue;
            }
            if (bond.getOrder() == IBond.Order.SINGLE) {
                ++ac2SingleBondCount;
                continue;
            }
            if (bond.getOrder() == IBond.Order.DOUBLE) {
                ++ac2DoubleBondCount;
                continue;
            }
            if (bond.getOrder() != IBond.Order.TRIPLE) continue;
            ++ac2TripleBondCount;
        }
        if (ac2SingleBondCount > ac1SingleBondCount) {
            return false;
        }
        if (ac2AromaticBondCount > ac1AromaticBondCount) {
            return false;
        }
        if (ac2DoubleBondCount > ac1DoubleBondCount) {
            return false;
        }
        if (ac2TripleBondCount > ac1TripleBondCount) {
            return false;
        }
        for (i = 0; i < ac1.getAtomCount(); ++i) {
            atom = ac1.getAtom(i);
            if (atom.getSymbol().equals("S")) {
                ++ac1SCount;
                continue;
            }
            if (atom.getSymbol().equals("N")) {
                ++ac1NCount;
                continue;
            }
            if (atom.getSymbol().equals("O")) {
                ++ac1OCount;
                continue;
            }
            if (atom.getSymbol().equals("F")) {
                ++ac1FCount;
                continue;
            }
            if (atom.getSymbol().equals("Cl")) {
                ++ac1ClCount;
                continue;
            }
            if (atom.getSymbol().equals("Br")) {
                ++ac1BrCount;
                continue;
            }
            if (atom.getSymbol().equals("I")) {
                ++ac1ICount;
                continue;
            }
            if (!atom.getSymbol().equals("C")) continue;
            ++ac1CCount;
        }
        for (i = 0; i < ac2.getAtomCount(); ++i) {
            atom = ac2.getAtom(i);
            if (atom instanceof IQueryAtom) continue;
            if (atom.getSymbol().equals("S")) {
                ++ac2SCount;
                continue;
            }
            if (atom.getSymbol().equals("N")) {
                ++ac2NCount;
                continue;
            }
            if (atom.getSymbol().equals("O")) {
                ++ac2OCount;
                continue;
            }
            if (atom.getSymbol().equals("F")) {
                ++ac2FCount;
                continue;
            }
            if (atom.getSymbol().equals("Cl")) {
                ++ac2ClCount;
                continue;
            }
            if (atom.getSymbol().equals("Br")) {
                ++ac2BrCount;
                continue;
            }
            if (atom.getSymbol().equals("I")) {
                ++ac2ICount;
                continue;
            }
            if (!atom.getSymbol().equals("C")) continue;
            ++ac2CCount;
        }
        if (ac1SCount < ac2SCount) {
            return false;
        }
        if (ac1NCount < ac2NCount) {
            return false;
        }
        if (ac1OCount < ac2OCount) {
            return false;
        }
        if (ac1FCount < ac2FCount) {
            return false;
        }
        if (ac1ClCount < ac2ClCount) {
            return false;
        }
        if (ac1BrCount < ac2BrCount) {
            return false;
        }
        if (ac1ICount < ac2ICount) {
            return false;
        }
        return ac1CCount >= ac2CCount;
    }

    protected static synchronized double getTimeout() {
        return TimeOut.getInstance().getTimeOut();
    }

    protected static synchronized TimeManager getTimeManager() {
        return timeManager;
    }

    protected static synchronized void setTimeManager(TimeManager aTimeManager) {
        TimeOut.getInstance().setTimeOutFlag(false);
        timeManager = aTimeManager;
    }

    public static synchronized boolean isTimeOut() {
        if (CDKMCS.getTimeout() > -1.0 && CDKMCS.getTimeManager().getElapsedTimeInMinutes() > CDKMCS.getTimeout()) {
            TimeOut.getInstance().setTimeOutFlag(true);
            return true;
        }
        return false;
    }
}

