/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Util;
import com.hp.hpl.jena.graph.query.ValuatorSet;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.Iterator;
import java.util.Set;

public class GuardArranger {
    protected Set<String>[] boundVariables;
    protected int size;

    public GuardArranger(Triple[] triples) {
        this.size = triples.length;
        this.boundVariables = this.makeBoundVariables(triples);
    }

    protected Set<String>[] makeBoundVariables(Triple[] triples) {
        int length = triples.length;
        Set[] result = new Set[length];
        Set<Object> prev = CollectionFactory.createHashedSet();
        for (int i = 0; i < length; ++i) {
            result[i] = Util.union(prev, Util.variablesOf(triples[i]));
            prev = result[i];
        }
        return result;
    }

    public ValuatorSet[] makeGuards(Mapping map, ExpressionSet constraints) {
        return this.makeGuards(map, constraints, this.size);
    }

    protected ValuatorSet[] makeGuards(Mapping map, ExpressionSet constraints, int length) {
        ValuatorSet[] result = new ValuatorSet[length];
        for (int i = 0; i < length; ++i) {
            result[i] = new ValuatorSet();
        }
        Iterator<Expression> it = constraints.iterator();
        while (it.hasNext()) {
            this.plantWhereFullyBound(it.next(), it, map, result);
        }
        return result;
    }

    protected void plantWhereFullyBound(Expression e, Iterator<Expression> it, Mapping map, ValuatorSet[] es) {
        for (int i = 0; i < this.boundVariables.length; ++i) {
            if (!this.canEval(e, i)) continue;
            es[i].add(e.prepare(map));
            it.remove();
            return;
        }
    }

    protected boolean canEval(Expression e, int index) {
        return Expression.Util.containsAllVariablesOf(this.boundVariables[index], e);
    }
}

