/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.setting;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.openscience.cdk.interfaces.ISetting;

public class SettingManager<T extends ISetting> {
    private static final Pattern WHITE_SPACE = Pattern.compile("\\s+");
    private Map<String, T> settings = new HashMap<String, T>(3);

    private static String key(String name) {
        return WHITE_SPACE.matcher(name).replaceAll(".").toLowerCase(Locale.ENGLISH);
    }

    private static String key(ISetting setting) {
        return SettingManager.key(setting.getName());
    }

    public T add(T setting) {
        ISetting instance;
        String key = SettingManager.key(setting);
        if (this.settings.containsKey(key) && (instance = (ISetting)this.settings.get(key)).getClass() == setting.getClass()) {
            return (T)instance;
        }
        this.settings.put(SettingManager.key(setting), setting);
        return setting;
    }

    public <S extends T> S get(String name) {
        String key = SettingManager.key(name);
        if (this.settings.containsKey(key)) {
            return (S)((ISetting)this.settings.get(key));
        }
        throw new InvalidParameterException("No setting found for name " + name + "(key=" + key + ") available settings are: " + this.settings.keySet());
    }

    public <S extends T> S get(String name, Class<S> c) {
        return this.get(name);
    }

    public boolean has(String name) {
        return this.settings.containsKey(SettingManager.key(name));
    }

    public Collection<T> getSettings() {
        return this.settings.values();
    }

    public T[] toArray(T[] c) {
        return (ISetting[])this.getSettings().toArray(c);
    }
}

