% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cateNelson.r
\name{cateNelson}
\alias{cateNelson}
\title{Cate-Nelson models for bivariate data}
\usage{
cateNelson(x, y, plotit = TRUE, hollow = TRUE, xlab = "X", ylab = "Y",
  trend = "positive", clx = 1, cly = 1, xthreshold = 0.1,
  ythreshold = 0.1)
}
\arguments{
\item{x}{A vector of values for the x variable.}

\item{y}{A vector of values for the y variable.}

\item{plotit}{If \code{TRUE}, produces plots of the output.}

\item{hollow}{If \code{TRUE}, uses hollow circles on the plot to indicate
data not fitting the model.}

\item{xlab}{The label for the x-axis.}

\item{ylab}{The label for the y-axis.}

\item{trend}{\code{"postive"} if the trend of y vs. x is generally
positive. \code{"negative"} if negative.}

\item{clx}{Indicates which of the listed critical x values 
should be chosen as the critical x value for the final model.}

\item{cly}{Indicates which of the listed critical y values 
should be chosen as the critical y value for the final model.}

\item{xthreshold}{Indicates the proportion of potential critical x values
to display in the output. A value of \code{1} would display
all of them.}

\item{ythreshold}{Indicates the proportion of potential critical y values
to display in the output. A value of \code{1} would display
all of them.}
}
\value{
A data frame of statistics from the analysis: number of observations,
        critical level for x, sum of squares, critical value for y, the
        number of observations in each of the quadrants (I, II, III, IV),
        the number of observations that conform with the model, 
        the proportion of observations that conform with the model, 
        the number of observations that do not conform to the model,
        the proportion of observations that do not conform to the model,
        and a p-value for the Fisher exact test for the data divided into
        the groups indicated by the model.
        
        Output also includes printed lists of critical values,
        explanation of the values in the data frame,
        and plots: y vs. x; sum of squares vs. critical x value;
        the number of observations that do not conform to the model vs.
        critical y value; 
        and y vs. x with the critical values shown as lines on the plot, 
        and the quadrants labeled.
}
\description{
Produces critical-x and critical-y values for bivariate data
             according to a Cate-Nelson analysis.
}
\details{
Cate-Nelson analysis divides bivariate data into two groups.
          For data with a positive trend, one group has a
          large \code{x} value associated with a large \code{y} value, and   
          the other group has a small \code{x} value associated with a small   
          \code{y} value. For a negative trend, a small \code{x} is
          associated with a large \code{y}, and so on. 
          
          The analysis is useful for bivariate data which don't conform well
          to linear, curvilinear, or plateau models.
          
          This function will fail if either of the largest two or smallest 
          two x values are identical.
}
\note{
The method in this function follows \cite{Cate, R. B., & Nelson, L.A. 
       (1971). A simple statistical procedure for partitioning soil test 
       correlation data into two classes. Soil Science Society of America 
       Proceedings 35, 658-660.}
          
       An earlier version of this function was published in \cite{Mangiafico, 
       S.S. 2013. Cate-Nelson Analysis for Bivariate Data Using 
       R-project. J.of Extension 51:5, 5TOT1.}
}
\examples{
data(Nurseries)
cateNelson(x          = Nurseries$Size,
           y          = Nurseries$Proportion,
           plotit     = TRUE,
           hollow     = TRUE,
           xlab       = "Nursery size in hectares",
           ylab       = "Proportion of good practices adopted",
           trend      = "positive",
           clx        = 1,
           xthreshold = 0.10,
           ythreshold = 0.15)

}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/rcompanion/h_02.html}
}
\concept{
Cate Nelson bivariate soil agronomy
}

