% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwisePermutationTest.r
\name{pairwisePermutationTest}
\alias{pairwisePermutationTest}
\title{Pairwise two-sample permutation tests}
\usage{
pairwisePermutationTest(x, g, method = "fdr", ...)
}
\arguments{
\item{x}{The response variable as a vector.}

\item{g}{The grouping variable as a vector.}

\item{method}{The p-value adjustment method to use for multiple tests.
See \code{\link{p.adjust}}.}

\item{...}{Additional arguments passed to
\code{\link{independence_test}}.}
}
\value{
A dataframe of the groups being compared, the p-values,
        and the adjusted p-values.
}
\description{
Conducts pairwise two-sample permutation tests across groups.
}
\details{
Permutation tests are non-parametric tests 
         that do not assume normally-distributed errors.
         See \url{http://rcompanion.org/rcompanion/d_06a.html} for
         futher discussion of this test.

         The \code{pairwisePermutationTest} function
         can be used as a post-hoc method following an omnibus 
         permutation test
         analogous to a one-way analysis of variance.
}
\examples{
data(PoohPiglet)
PoohPiglet = PoohPiglet[order(factor(PoohPiglet$Speaker, 
                        levels=c("Pooh", "Tigger", "Piglet"))),]
pairwisePermutationTest(x      = PoohPiglet$Likert,
                        g      = PoohPiglet$Speaker,
                        method = "fdr")

}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/handbook/K_02.html}
}
\seealso{
\code{\link{pairwisePermutationMatrix}}
}
\concept{
permutation nonparametric post-hoc one-way
}

