% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupwiseHuber.r
\name{groupwiseHuber}
\alias{groupwiseHuber}
\title{Groupwise Huber M-estimators and confidence intervals}
\usage{
groupwiseHuber(
  formula = NULL,
  data = NULL,
  var = NULL,
  group = NULL,
  conf.level = 0.95,
  ci.type = "wald",
  ...
)
}
\arguments{
\item{formula}{A formula indicating the measurement variable and
the grouping variables. e.g. y ~ x1 + x2.}

\item{data}{The data frame to use.}

\item{var}{The measurement variable to use. The name is in double quotes.}

\item{group}{The grouping variable to use. The name is in double quotes.
Multiple names are listed as a vector. (See example.)}

\item{conf.level}{The confidence interval to use.}

\item{ci.type}{The type of confidence interval to use. Can be
\code{"wald"} or \code{"boot"}.
See \code{HuberM} for details.}

\item{...}{Other arguments passed to the \code{HuberM} function.}
}
\value{
A data frame of requested statistics by group.
}
\description{
Calculates Huber M-estimator and confidence intervals for
             groups.
}
\details{
A wrapper for the \code{DescTools::HuberM} function
         to allow easy output for multiple groups.
         
         The input should include either \code{formula} and \code{data};
             or \code{data}, \code{var}, and \code{group}. (See examples).
             
         Results for ungrouped (one-sample) data can be obtained by either
         setting the right side of the formula to 1, e.g.  y ~ 1, or by
         setting \code{group=NULL}.
}
\note{
The parsing of the formula is simplistic. The first variable on the
         left side is used as the measurement variable.  The variables on the
         right side are used for the grouping variables.          
         
         It is recommended to remove \code{NA} values before using this
         function.  At the time of writing, \code{NA} values will cause the
         function to fail.
         
         At the time of writing, the \code{ci.type="boot"} option
         produces \code{NA} results. This is a result from the
         \code{DescTools::HuberM} function.
}
\examples{
### Example with formula notation
data(Catbus)
groupwiseHuber(Steps ~ Teacher + Gender,
               data      = Catbus,
               ci.type   = "wald")
               
### Example with variable notation
data(Catbus)
groupwiseHuber(data      = Catbus,
               var       = "Steps",
               group     = c("Teacher", "Gender"),
               ci.type   = "wald")
                                      
}
\references{
\url{http://rcompanion.org/rcompanion/d_08a.html}
}
\seealso{
\code{\link{groupwiseMean}}, \code{\link{groupwiseMedian}}
         \code{\link{groupwiseGeometric}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{huber m-estimator confidence interval robust bootstrap}
