% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack.R
\name{stack}
\alias{stack}
\title{Stack}
\usage{
stack(
  name = NULL,
  simulations,
  path = NULL,
  global,
  species,
  climate,
  daily,
  lidar = NULL,
  forest = NULL,
  verbose = TRUE,
  cores = NULL,
  overwrite = TRUE,
  thin = NULL
)
}
\arguments{
\item{name}{char. Stack name (if NULL timestamp).}

\item{simulations}{char. Simulation names.}

\item{path}{char. Path to save the simulation outputs, the default is null
corresponding to a simulation in memory without saved intermediary files.}

\item{global}{df. Global parameters.}

\item{species}{df. Species parameters.}

\item{climate}{df. Climate parameters.}

\item{daily}{df. Daily variation parameters.}

\item{lidar}{df. Lidar simulation parameters, if null no computed
(default NULL).}

\item{forest}{df. TROLL with forest input, if null starts from an empty grid
(default NULL).}

\item{verbose}{bool. Show TROLL outputs in the console.}

\item{cores}{int. Number of cores for parallelization, if NULL available
cores - 1 (default NULL).}

\item{overwrite}{bool. Overwrite previous outputs.}

\item{thin}{int. Vector of integers corresponding to the iterations to be
kept to reduce output size, default is NULL and corresponds to no
thinning.}
}
\value{
A trollstack object.
}
\description{
Run a TROLL stack.
}
\examples{
\dontrun{
data("TROLLv3_species")
data("TROLLv3_climatedaytime12")
data("TROLLv3_daytimevar")
data("TROLLv3_output")
TROLLv3_input_stack <- generate_parameters(
  cols = 100, rows = 100,
  iterperyear = 12, nbiter = 12 * 1
) \%>\%
  mutate(simulation = list(c("seed50000", "seed500"))) \%>\%
  unnest(simulation)
TROLLv3_input_stack[62, 2] <- 500 # Cseedrain
stack(
  name = "teststack",
  simulations = c("seed50000", "seed500"),
  global = TROLLv3_input_stack,
  species = TROLLv3_species,
  climate = TROLLv3_climatedaytime12,
  daily = TROLLv3_daytimevar,
  verbose = F,
  cores = 2,
  thin = c(1, 5, 10)
)
}

}
