% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrd_power.R
\name{mrd_power}
\alias{mrd_power}
\title{Power Analysis of Multivariate Regression Discontinuity}
\usage{
mrd_power(num.rep = 100, sample.size = 100, x1.dist = "normal",
  x1.para = c(0, 1), x2.dist = "normal", x2.para = c(0, 1), x1.cut = 0,
  x2.cut = 0, x1.fuzzy = c(0, 0), x2.fuzzy = c(0, 0), x1.design = "l",
  x2.design = "l", coeff = c(0.1, 0.5, 0.5, 1, rep(0.1, 9)), eta.sq = 0.5,
  alpha.list = c(0.001, 0.01, 0.05))
}
\arguments{
\item{num.rep}{Number of repetitions used to calculate the empirical alpha.}

\item{sample.size}{Number of observations in each sample.}

\item{x1.dist}{Distribution of the 1st assignment variable X1.
\code{"normal"} distribution is the default. 
\code{"uniform"} distribution is the only other option.}

\item{x1.para}{Parameters of the distribution of the 1st assignment variable X1.
If \code{x1.dist} is \code{"normal"}, then \code{x1.para} includes the
mean and sd of normal distribution.
If \code{x1.dist} is \code{"uniform"}, then \code{x1.para} includes the 
upper and lower boundaries of uniform distribution.}

\item{x2.dist}{Distribution of the 2nd assignment variable X2.}

\item{x2.para}{Parameters of the distribution of the 2nd assignment variable X2.}

\item{x1.cut}{Cutpoint of RD with respect to the 1st assignment variable X1.}

\item{x2.cut}{Cutpoint of RD with respect to the 2nd assignment variable X2.}

\item{x1.fuzzy}{Probabilities to be assigned to control in terms of the 1st
assignment variable X1 for individuals in treatment based on cutoff, 
and to treatment for individuals in control based on cutoff.
For a sharp design, by default, the 1st entry is 0, and the 2nd entry is 0. 
For a fuzzy design, the 1st entry is the probability to be assigned to 
control for individuals above the cutpoint, and the 2nd entry is the 
probability to be assigned to treatment for individuals below the cutpoint.}

\item{x2.fuzzy}{Probabilities to be assigned to control in terms of the 2nd
assignment variable X2 for individuals in treatment based on cutoff, 
and to treatment for individuals in control based on cutoff.}

\item{x1.design}{The treatment option according to design.
The entry is for X1: \code{"g"} means treatment is assigned 
if X1 is greater than its cutoff, \code{"geq"} means treatment is assigned 
if X1 is greater than or equal to its cutoff, \code{"l"} means treatment is assigned 
if X1 is less than its cutoff, \code{"leq"} means treatment is assigned 
if X1 is less than or equal to its cutoff.}

\item{x2.design}{The treatment option according to design.
The entry is for X2.}

\item{coeff}{Coefficients of variables in the linear model to generate data
The 1st entry is the intercept. 
The 2nd entry is the slope of treatment 1, i.e. treatment effect 1.
The 3rd entry is the slope of treatment 2, i.e. treatment effect 2.
The 4th entry is the slope of treatment, i.e. treatment effect.
The 5th entry is the slope of assignment 1.
The 6th entry is the slope of assignment 2.
The 7th entry is the slope of interaction between assignment 1 and assignment 2.
The 8th entry is the slope of interaction between treatment 1 and assignment 1.
The 9th entry is the slope of interaction between treatment 2 and assignment 1.
The 10th entry is the slope of interaction between treatment 1 and assignment 2.
The 11th entry is the slope of interaction between treatment 2 and assignment 2.
The 12th entry is the slope of interaction between treatment 1, assignment 1 and assignment 2.
The 13th entry is the slope of interaction between treatment 2, assignment 1 and assignment 2.}

\item{eta.sq}{Expected partial eta-squared of the linear model with respect to the 
treatment itself. It is used to control the variance of noise in the linear model.}

\item{alpha.list}{List of significance levels used to calculate the empirical alpha.}
}
\value{
\code{mrd_power} returns the results of 6 estimators as a table, 
  including mean, variance, and power of estimate.
  The 1st \code{Linear} results of the linear regression estimator 
  of combined RD using the centering approach.
  The 2nd \code{Opt} results of the local linear regression estimator
  of combined RD using the centering approach, 
  with the optimal bandwidth in the IK 2012 paper.
  The 3rd \code{Linear} results of the linear regression estimator 
  of separate RD in terms of x1 using the univariate approach.
  The 4th \code{Opt} results of the local linear regression estimator
  of separate RD in terms of x1 using the univariate approach, 
  with the optimal bandwidth in the IK 2012 paper.
  The 5th \code{Linear} results of the linear regression estimator 
  of separate RD in terms of x2 using the univariate approach.
  The 6th \code{Opt} results of the local linear regression estimator
  of separate RD in terms of x2 using the univariate approach, 
  with the optimal bandwidth in the IK 2012 paper.
}
\description{
\code{mrd_power} computes the empirical probability that RD is significant,
i.e. the empirical alpha of null hypothesis: RD = 0
}
\examples{
\dontrun{
mrd_power()
mrd_power(x1.dist = "uniform", x1.cut = 0.5)
mrd_power(x1.fuzzy = c(0.1, 0.1))
}
}
