% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wt_kern_bivariate.R
\name{wt_kern_bivariate}
\alias{wt_kern_bivariate}
\title{Bivariate Kernel Weight Calculation}
\usage{
wt_kern_bivariate(
  X1,
  X2,
  center1,
  center2,
  bw,
  kernel = "triangular",
  t.design = NULL
)
}
\arguments{
\item{X1}{The input x1 values for the first vector. 
This variable represents the axis along which kernel weighting should be performed.}

\item{X2}{The input x2 values for the second vector. \code{X2} has the same length as \code{X1}.
This variable represents the axis along which kernel weighting should be performed.}

\item{center1}{The point from which distances should be calculated for the first vector.}

\item{center2}{The point from which distances should be calculated for the second vector.}

\item{bw}{A numeric vector specifying the bandwidths for each of three effects models}

\item{kernel}{A string indicating the kernel to use. Options are \code{"triangular"} (the default), 
\code{"epanechnikov"}, \code{"quartic"}, \code{"triweight"}, \code{"tricube"}, \code{"gaussian"},
and \code{"cosine"}.}

\item{t.design}{The treatment option according to design.
The 1st entry is for X1: \code{"g"} means treatment is assigned 
if X1 is greater than its cutoff, \code{"geq"} means treatment is assigned 
if X1 is greater than or equal to its cutoff, \code{"l"} means treatment is assigned 
if X1 is less than its cutoff, \code{"leq"} means treatment is assigned 
if X1 is less than or equal to its cutoff.
The 2nd entry is for X2.}
}
\value{
Three vectors of weights and distances with length equal to that of the \code{X1} and \code{X2} input.
  The first and second weights and distances are calculated with respect to all frontiers of different treatments.
  The third weight and distance are calculated with respect to the overall frontier of treatment versus
  non-treatment.
}
\description{
\code{wt_kern_bivariate} calculates the appropriate weights for two variables
   for nonparametric implementation of Multivariate Frontier Regression Discontinuity Estimation.
   Kernel weights are calculated based on the L1 distance of the two variables from the frontiers.
}
