% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arborescence.R
\docType{class}
\name{Arborescence}
\alias{Arborescence}
\title{A rooted directed tree}
\description{
An R6 class representing an \dfn{arborescence} (a rooted 
directed tree).
}
\details{
Class to encapsulate a directed rooted tree specialization of a 
digraph. An arborescence is a directed tree with exactly one root and 
unique directed paths from the root. Inherits from class \code{Digraph}.
}
\references{
{
  Walker, John Q II. A A node-positioning algorithm for general trees.
  University of North Carolina Technical Report \acronym{TR} 89-034, 1989.
}
}
\author{
Andrew Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super classes}{
\code{\link[rdecision:Graph]{rdecision::Graph}} -> \code{\link[rdecision:Digraph]{rdecision::Digraph}} -> \code{Arborescence}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Arborescence$new()}}
\item \href{#method-is_parent}{\code{Arborescence$is_parent()}}
\item \href{#method-is_leaf}{\code{Arborescence$is_leaf()}}
\item \href{#method-root}{\code{Arborescence$root()}}
\item \href{#method-siblings}{\code{Arborescence$siblings()}}
\item \href{#method-root_to_leaf_paths}{\code{Arborescence$root_to_leaf_paths()}}
\item \href{#method-postree}{\code{Arborescence$postree()}}
\item \href{#method-clone}{\code{Arborescence$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="degree">}\href{../../rdecision/html/Graph.html#method-degree}{\code{rdecision::Graph$degree()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="edge_index">}\href{../../rdecision/html/Graph.html#method-edge_index}{\code{rdecision::Graph$edge_index()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="graph_adjacency_matrix">}\href{../../rdecision/html/Graph.html#method-graph_adjacency_matrix}{\code{rdecision::Graph$graph_adjacency_matrix()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="has_edge">}\href{../../rdecision/html/Graph.html#method-has_edge}{\code{rdecision::Graph$has_edge()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="has_vertex">}\href{../../rdecision/html/Graph.html#method-has_vertex}{\code{rdecision::Graph$has_vertex()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="is_simple">}\href{../../rdecision/html/Graph.html#method-is_simple}{\code{rdecision::Graph$is_simple()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="neighbours">}\href{../../rdecision/html/Graph.html#method-neighbours}{\code{rdecision::Graph$neighbours()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="order">}\href{../../rdecision/html/Graph.html#method-order}{\code{rdecision::Graph$order()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="size">}\href{../../rdecision/html/Graph.html#method-size}{\code{rdecision::Graph$size()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="vertex_index">}\href{../../rdecision/html/Graph.html#method-vertex_index}{\code{rdecision::Graph$vertex_index()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="as_DOT">}\href{../../rdecision/html/Digraph.html#method-as_DOT}{\code{rdecision::Digraph$as_DOT()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="digraph_adjacency_matrix">}\href{../../rdecision/html/Digraph.html#method-digraph_adjacency_matrix}{\code{rdecision::Digraph$digraph_adjacency_matrix()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="digraph_incidence_matrix">}\href{../../rdecision/html/Digraph.html#method-digraph_incidence_matrix}{\code{rdecision::Digraph$digraph_incidence_matrix()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="direct_predecessors">}\href{../../rdecision/html/Digraph.html#method-direct_predecessors}{\code{rdecision::Digraph$direct_predecessors()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="direct_successors">}\href{../../rdecision/html/Digraph.html#method-direct_successors}{\code{rdecision::Digraph$direct_successors()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="is_acyclic">}\href{../../rdecision/html/Digraph.html#method-is_acyclic}{\code{rdecision::Digraph$is_acyclic()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="is_arborescence">}\href{../../rdecision/html/Digraph.html#method-is_arborescence}{\code{rdecision::Digraph$is_arborescence()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="is_connected">}\href{../../rdecision/html/Digraph.html#method-is_connected}{\code{rdecision::Digraph$is_connected()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="is_polytree">}\href{../../rdecision/html/Digraph.html#method-is_polytree}{\code{rdecision::Digraph$is_polytree()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="is_tree">}\href{../../rdecision/html/Digraph.html#method-is_tree}{\code{rdecision::Digraph$is_tree()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="is_weakly_connected">}\href{../../rdecision/html/Digraph.html#method-is_weakly_connected}{\code{rdecision::Digraph$is_weakly_connected()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="paths">}\href{../../rdecision/html/Digraph.html#method-paths}{\code{rdecision::Digraph$paths()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="topological_sort">}\href{../../rdecision/html/Digraph.html#method-topological_sort}{\code{rdecision::Digraph$topological_sort()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="walk">}\href{../../rdecision/html/Digraph.html#method-walk}{\code{rdecision::Digraph$walk()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Arborescence} object from sets of nodes and edges.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arborescence$new(V, A)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{V}}{A list of Nodes.}

\item{\code{A}}{A list of Arrows.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{Arborescence} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_parent"></a>}}
\if{latex}{\out{\hypertarget{method-is_parent}{}}}
\subsection{Method \code{is_parent()}}{
Test whether the given node is a parent (has child nodes).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arborescence$is_parent(v)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{Node to test}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if v has one or more child nodes, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_leaf"></a>}}
\if{latex}{\out{\hypertarget{method-is_leaf}{}}}
\subsection{Method \code{is_leaf()}}{
Test whether the given node is a leaf. In an arborescence,
\code{is_parent()} and \code{is_leaf()} are mutually exclusive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arborescence$is_leaf(v)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{Vertex to test.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if v has no child nodes, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-root"></a>}}
\if{latex}{\out{\hypertarget{method-root}{}}}
\subsection{Method \code{root()}}{
Find the root vertex of the arborescence.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arborescence$root()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The root vertex.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-siblings"></a>}}
\if{latex}{\out{\hypertarget{method-siblings}{}}}
\subsection{Method \code{siblings()}}{
Find the siblings of a vertex in the arborescence.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arborescence$siblings(v)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{Vertex to test.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A (possibly empty) list of siblings.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-root_to_leaf_paths"></a>}}
\if{latex}{\out{\hypertarget{method-root_to_leaf_paths}{}}}
\subsection{Method \code{root_to_leaf_paths()}}{
Find all directed paths from the root of the tree to the leaves.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arborescence$root_to_leaf_paths()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of ordered node lists.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-postree"></a>}}
\if{latex}{\out{\hypertarget{method-postree}{}}}
\subsection{Method \code{postree()}}{
Implements function \verb{POSITIONTREE} (Walker, 1989) to
determine the coordinates for each node in an arborescence.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arborescence$postree(
  SiblingSeparation = 4,
  SubtreeSeparation = 4,
  LevelSeparation = 1,
  RootOrientation = "SOUTH",
  MaxDepth = Inf
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{SiblingSeparation}}{Distance in arbitrary units for the
distance between siblings.}

\item{\code{SubtreeSeparation}}{Distance in arbitrary units for the
distance between neighbouring subtrees.}

\item{\code{LevelSeparation}}{Distance in arbitrary units for the 
separation between adjacent levels.}

\item{\code{RootOrientation}}{Must be one of "NORTH", "SOUTH", "EAST", "WEST".
Defined as per Walker (1989), but noting that Walker assumed that
y increased down the page. Thus the meaning of NORTH and SOUTH are
opposite to his, with the default (SOUTH) having the child nodes at
positive y value and root at zero, as per his example (figure 12).}

\item{\code{MaxDepth}}{The maximum depth (number of levels) to be drawn; if
the tree exceeds this, an error will be raised.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame with one row per node and three columns (n, x
and y) where \code{n} gives the node index given by the 
\code{Graph::vertex_index()} function.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arborescence$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
