% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DaiAuthenticationKeyService.R
\name{dfp_createDaiAuthenticationKeys}
\alias{dfp_createDaiAuthenticationKeys}
\title{DaiAuthenticationKeyService}
\usage{
dfp_createDaiAuthenticationKeys(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createDaiAuthenticationKeysResponse
}
\description{
Provides methods for creating, updating and retrieving DaiAuthenticationKey
objects.
}
\details{
createDaiAuthenticationKeys

Creates new DaiAuthenticationKey objects.
The following fields are required: 
\itemize{
  \item{DaiAuthenticationKey name}
}
}
\examples{
\dontrun{
 res <- dfp_createDaiAuthenticationKeys(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201905/DaiAuthenticationKeyService#createDaiAuthenticationKeys}{Google Documentation for createDaiAuthenticationKeys}
}
