% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReportService.R
\name{dfp_getReportDownloadUrlWithOptions}
\alias{dfp_getReportDownloadUrlWithOptions}
\title{getReportDownloadUrlWithOptions}
\usage{
dfp_getReportDownloadUrlWithOptions(request_data, as_df = FALSE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getReportDownloadUrlWithOptionsResponse
}
\description{
Returns the URL at which the report file can be downloaded, and allows for customization of the downloaded report.
By default, the report will be generated as a gzip archive, containing the report file itself. This can be changed by setting ReportDownloadOptions useGzipCompression to false.
}
\examples{
\dontrun{
 res <- dfp_getReportDownloadUrlWithOptions(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201905/ReportService#getReportDownloadUrlWithOptions}{Google Documentation for getReportDownloadUrlWithOptions}
}
