% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_media.R
\name{drop_media}
\alias{drop_media}
\title{Returns a link directly to a file.}
\usage{
drop_media(path = NULL, dtoken = get_dropbox_token())
}
\arguments{
\item{path}{This is required The path to the new folder to create relative to
root.}

\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}. rdrop2
will try to automatically locate your local credential cache and use them.
However, if the credentials are not found, the function will initiate a new
authentication request. You can override this in \code{\link{drop_auth}} by
pointing to a different location where your credentials are stored.}
}
\description{
Similar to \code{drop_shared}. The difference is that this bypasses the
Dropbox webserver, used to provide a preview of the file, so that you can
effectively stream the contents of your media. This URL should not be used to
display content directly in the browser. IMPORTANT: The media link will expire
after 4 hours. So you'll need to cache the content with knitr cache OR re-run
the function call after expiry.
}
\examples{
\dontrun{
drop_media('Public/gifs/duck_rabbit.gif')
}
}
\references{
\href{https://www.dropbox.com/developers/documentation/http/documentation#files-get_temporary_link}{API documentation}
}
