% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_to_integer.R
\name{convert_to_integer}
\alias{convert_to_integer}
\title{Convert a raster to integer format}
\usage{
convert_to_integer(x, out)
}
\arguments{
\item{x}{A raster layer in the current GRASS mapset.}

\item{out}{Name of the output raster. Avoid names with hyphens.}
}
\value{
Nothing. A raster with the name \code{out} will be added to the current GRASS mapset.
}
\description{
Given a raster in float, double or any other format, this function will convert it to integer format. This can be important because it is often an unstated requirement of GRASS modules such as the one for zonal statistics.
}
\examples{
# Will only run if GRASS is running
if(check_running()){

# Load data set
dem <- system.file("extdata", "dem.tif", package = "rdwplus")

# Set environment 
set_envir(dem)

# Make an integer-valued version of 'dem.tif'
convert_to_integer("dem.tif", "int_dem.tif")

# Compare
plot_GRASS("dem.tif")
plot_GRASS("int_dem.tif")

}
}
