% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attr.R
\name{get_named_groups}
\alias{get_named_groups}
\title{Return capturing names for a pre-compiled regular expression.}
\usage{
get_named_groups(pattern, ...)
}
\arguments{
\item{pattern}{a pre-compiled regular expression or a string}

\item{...}{further arguments passed to \code{\link{re2}}}
}
\value{
capturing names
}
\description{
Return capturing names.
}
\examples{
get_named_groups(re2("(a)(?P<name>b)"))

regexp = re2("(?P<A>exprA(?P<B>exprB)(?P<C>exprC))((expr5)(?P<D>exprD))")

print(regexp)
(res = get_named_groups(regexp))
re2_match("exprAexprBexprCexpr5exprD", regexp)
}
