% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reReg.R
\name{reReg.control}
\alias{reReg.control}
\title{Package options for reReg}
\usage{
reReg.control(
  eqType = c("logrank", "gehan", "gehan_s"),
  solver = c("BB::dfsane", "BB::BBsolve", "BB::BBoptim", "optimx::optimr",
    "dfoptim::hjk", "dfoptim::mads", "optim", "nleqslv::nleqslv"),
  tol = 1e-07,
  init = list(alpha = 0, beta = 0, eta = 0, theta = 0),
  boot.parallel = FALSE,
  boot.parCl = NULL
)
}
\arguments{
\item{eqType}{a character string indicating whether the log-rank type estimating equation
or the Gehan-type estimating equation (when available) will be used.}

\item{solver}{a character string specifying the equation solver to be used for root search.}

\item{tol}{a numerical value specifying the absolute error tolerance in root search.}

\item{init}{a list contains the initial guesses used for root search.}

\item{boot.parallel}{an logical value indicating whether parallel computation will be
applied when \code{se = "boot"} is specified in \code{reReg()}.}

\item{boot.parCl}{an integer value specifying the number of CPU cores to be used when
\code{parallel = TRUE}. The default value is half the CPU cores on the current host.}
}
\description{
This function provides the fitting options for the \code{reReg()} function.
}
\seealso{
\code{\link{reReg}}
}
