% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{cyborg}
\alias{cyborg}
\title{Theme cyborg}
\usage{
cyborg(
  font_family = "Verdana",
  font_size = 14,
  font_color = "#888888",
  header_font_family = "Verdana",
  header_font_size = 15,
  header_font_color = "#7b7b7b",
  cell_padding = 6
)
}
\arguments{
\item{font_family}{Font family for the text within the table.
Default is Verdana.}

\item{font_size}{Numeric value representing the size of the font within the table (in px).
Default is 14.}

\item{font_color}{Color of the font for the text within the table and the group headers.
Default is #888888.}

\item{header_font_family}{Font family for the header text.
Default is Verdana.}

\item{header_font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{header_font_color}{Color of the font for the header text.
Default is #7b7b7b.}

\item{cell_padding}{Numeric value representing the padding size between cells (in px).
Default is 6.}
}
\value{
an object of class theme that is applied to a reactable table.
}
\description{
Bootstrap-inspired cyborg theme
}
\examples{
data <- iris[10:29, ]

## Standard cyborg theme
reactable(data,
          theme = cyborg())

## Cerulean theme with additional options applied
reactable(data,
          theme = cyborg(font_size = 12, font_color = "grey", cell_padding = 3))

}
