% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readGenalex.R
\name{is.genalex}
\alias{is.genalex}
\title{Check to see if an object is of class 'genalex'}
\usage{
is.genalex(x, force = FALSE, skip.strings = FALSE, skip.extra = FALSE,
  verbose = FALSE)
}
\arguments{
\item{x}{An object that might be of class \code{'genalex'}}

\item{force}{If \code{TRUE} and \code{x} has class \code{'genalex'},
force a deeper check to assure that the data and annotations are
consistent with class \code{'genalex'}}

\item{skip.strings}{If \code{TRUE} and \code{force = TRUE},
do not check the attributes \code{"dataset.title"} and
\code{"data.file.name"} for consistency.}

\item{skip.extra}{If \code{TRUE} and \code{force = TRUE}, do not
check the extra data columns (attribute \code{"extra.columns"} for
consistency.}

\item{verbose}{If \code{TRUE} and \code{force = TRUE}, indicate any
inconsistencies discovered between the data and annotations. if
there are no inconsistencies, nothing is printed.}
}
\value{
\code{TRUE} or \code{FALSE}
}
\description{
Check to see if an object is of class 'genalex' as recognised by
the \code{readGenalex} package.  With \code{force = TRUE},
the internal consistency of the data and annotations are checked.
}
\details{
Two attributes that may commonly be found to differ from inferred
values are \code{"dataset.title"} and \code{"data.file.name"},
if there have been manipulations to the class.  These attributes
cannot be removed from a valid object of class \code{'genalex'},
but they can be set to the empty string (\code{""}) to avoid this
check.  Alternatively, the option \code{skip.strings = TRUE} may
be set to not check these specific attributes for consistency.
Extra data columns are checked first for existence, then for contents,
then for matching row names.  The option \code{skip.extra = TRUE}
may be set to not check extra data columns.
}
\examples{
data(Qagr_adult_genotypes)
is.genalex(Qagr_adult_genotypes)
## create an inconsistent attribute
attr(Qagr_adult_genotypes, "n.loci") <- 20
## this doesn't detect the inconsistency
is.genalex(Qagr_adult_genotypes)
## this detects the inconsistency, returns FALSE
is.genalex(Qagr_adult_genotypes, force = TRUE)
is.genalex(Qagr_adult_genotypes, force = TRUE, verbose = TRUE)
}
\author{
Douglas G. Scofield
}

