% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readability-package.R, R/readability.R
\docType{package}
\name{readability}
\alias{package-readability}
\alias{readability}
\alias{readability-package}
\title{Calculate Readability Scores}
\usage{
readability(x, grouping.var, order.by.readability = TRUE, group.names, ...)
}
\arguments{
\item{x}{A character vector.}

\item{grouping.var}{The grouping variable(s).  Takes a single grouping
variable or a list of 1 or more grouping variables.}

\item{order.by.readability}{logical.  If \code{TRUE} orders the results
descending by readability score.}

\item{group.names}{A vector of names that corresponds to group.  Generally
for internal use.}

\item{\ldots}{ignored}
}
\value{
Returns a \code{\link[base]{data.frame}}
(\code{\link[data.table]{data.table}}) readability scores.
}
\description{
A collection of readability tools that utilize the
\href{https://github.com/trinker/syllable}{\pkg{syllable}} package for fast
calculation of readability scores by grouping variables.

Calculate the Flesch Kincaid, Gunning Fog Index, Coleman Liau, SMOG,
Automated Readability Index and an average of the 5 readability scores.
}
\examples{
\dontrun{
library(syllable)

(x1 <- with(presidential_debates_2012, readability(dialogue, NULL)))

(x2 <- with(presidential_debates_2012, readability(dialogue, list(person, time))))
plot(x2)

(x2b <- with(presidential_debates_2012, readability(dialogue, list(person, time),
    order.by.readability = FALSE)))

(x3 <- with(presidential_debates_2012, readability(dialogue, TRUE)))
}
}
\references{
Coleman, M., & Liau, T. L. (1975). A computer readability formula
designed for machine scoring. Journal of Applied Psychology, Vol. 60,
pp. 283-284.

Flesch R. (1948). A new readability yardstick. Journal of Applied Psychology.
Vol. 32(3), pp. 221-233. doi: 10.1037/h0057532.

Gunning, Robert (1952). The Technique of Clear Writing. McGraw-Hill. pp. 36-37.

McLaughlin, G. H. (1969). SMOG Grading: A New Readability Formula.
Journal of Reading, Vol. 12(8), pp. 639-646.

Smith, E. A. & Senter, R. J. (1967) Automated readability index.
Technical Report AMRLTR-66-220, University of Cincinnati, Cincinnati, Ohio.
}
\keyword{Automated}
\keyword{Coleman}
\keyword{Flesch-Kincaid,}
\keyword{Fry,}
\keyword{Index,}
\keyword{Liau,}
\keyword{Linsear}
\keyword{Readability}
\keyword{SMOG,}
\keyword{Write}
\keyword{readability,}

