% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_delim}
\alias{format_csv}
\alias{format_delim}
\alias{format_tsv}
\alias{output_column}
\alias{write_csv}
\alias{write_delim}
\alias{write_tsv}
\title{Save a data frame to a delimited file.}
\usage{
write_delim(x, path, delim = " ", na = "NA", append = FALSE,
  col_names = !append)

write_csv(x, path, na = "NA", append = FALSE, col_names = !append)

write_tsv(x, path, na = "NA", append = FALSE, col_names = !append)

format_csv(x, na = "NA", append = FALSE, col_names = !append)

format_tsv(x, na = "NA", append = FALSE, col_names = !append)

format_delim(x, delim, na = "NA", append = FALSE, col_names = !append)

output_column(x)
}
\arguments{
\item{x}{A data frame to write to disk}

\item{path}{Path to write to.}

\item{delim}{Delimiter used to seperate values. Defaults to \code{" "}. Must be
a single character.}

\item{na}{String used for missing values. Defaults to NA. Missing values
will never be quoted; strings with the same value as \code{na} will
always be quoted.}

\item{append}{If \code{FALSE}, will overwrite existing file. If \code{TRUE},
will append to existing file. In both cases, if file does not exist a new
file is created.}

\item{col_names}{Write columns names at the top of the file?}
}
\value{
\code{write_*} returns in the input \code{x} invisibily,
  \code{format_*} returns a string.
}
\description{
This is about twice as fast as \code{\link{write.csv}}, and never
writes row names. \code{output_column} is a generic method used to coerce
columns to suitable output.
}
\section{Output}{

Factors are coerced to character. Doubles are coerced to character to
take advantage of R's nice output for doubles. POSIXct's are formatted
as ISO8601.

All columns are encoded as UTF-8.

Values are only quoted if needed: if they contain a comma, quote or newline.

}
\examples{
tmp <- tempfile()
write_csv(mtcars, tmp)
head(read_csv(tmp))

# format_* is useful for testing and reprexes
cat(format_csv(head(mtcars)))
cat(format_tsv(head(mtcars)))
cat(format_delim(head(mtcars), ";"))

df <- data.frame(x = c(1, 2, NA))
format_csv(df, na = ".")

# Quotes are automatically as needed
df <- data.frame(x = c("a", '"', ",", "\\n"))
cat(format_csv(df))
}

