% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collectors.R
\name{parse_guess}
\alias{col_guess}
\alias{guess_parser}
\alias{parse_guess}
\title{Parse a character vector into the "best" type.}
\usage{
parse_guess(x, na = c("", "NA"), locale = default_locale())

col_guess()

guess_parser(x, locale = default_locale())
}
\arguments{
\item{x}{Character vector of values to parse.}

\item{na}{Character vector of strings to use for missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link{locale}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}
}
\description{
\code{parse_guess()} returns the parser vector; \code{guess_parser()}
returns the name of the parser. These functions use a number of heuristics
to determine which type of vector is "best". Generally they try to err of
the side of safety, as it's straightforward to override the parsing choice
if needed.
}
\examples{
# Logical vectors
parse_guess(c("FALSE", "TRUE", "F", "T"))

# Integers and doubles
parse_guess(c("1","2","3"))
parse_guess(c("1.6","2.6","3.4"))

# Numbers containing grouping mark
guess_parser("1,234,566")
parse_guess("1,234,566")

# ISO 8601 date times
guess_parser(c("2010-10-10"))
parse_guess(c("2010-10-10"))
}
\seealso{
Other parser: \code{\link{parse_atomic}},
  \code{\link{parse_datetime}}, \code{\link{parse_factor}},
  \code{\link{parse_number}}
}

