% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dana.R
\name{dana}
\alias{dana}
\title{Differential analysis (dana)}
\usage{
dana(
  X,
  sample_data,
  formula_rhs,
  term_LRT = NULL,
  model_control = list(),
  platform = c("ms", "nmr", "ngs"),
  assay = NULL,
  verbose = TRUE
)
}
\arguments{
\item{X}{A numeric matrix with samples in rows and features in columns. Sample
IDs in row names must match the format from \code{sample_id} column in \code{sample_data}.}

\item{sample_data}{A data frame containing sample-level data.
Must have a \code{sample_id} column matching row names in \code{X} and \code{sample_data}.}

\item{formula_rhs}{A one-sided formula (e.g., \code{~ group + (1|subject)}).
Must not contain a response variable.}

\item{term_LRT}{Optional. Character vector of formula terms to test via LRT.
Random effects must be written without parentheses (e.g., \code{"1 | group"}).}

\item{model_control}{Optional. List of control arguments passed to the model.}

\item{platform}{Character string indicating the omics platform (e.g., \code{"ms"}, \code{"nmr"}, \code{"ngs"}).}

\item{assay}{Optional. Character string indicating the name of the platform assay (e.g., \code{"lipidomics"}).}

\item{verbose}{Logical. If TRUE, prints progress messages.}
}
\value{
An object of class \code{"dana"}:
\describe{
\item{X}{Matched data matrix.}
\item{sdata}{Matched sample data.}
\item{fit}{Data frame of model coefficients and confidence intervals per feature.}
\item{lrt}{Likelihood ratio test results (if \code{term_LRT} is specified).}
\item{ranef}{Random effects variance components (if using mixed models).}
\item{errors}{A data frame logging any model fitting errors per feature.}
}
}
\description{
Feature-wise \code{stats::lm()} or \code{lme4::lmer()} models of an omics data matrix.
Supports likelihood ratio tests (LRT) and parallel computation.
}
\details{
Models are fit independently for each feature using \code{stats::lm()} or \code{lmerTest::lmer()},
depending on whether \code{dana()} detects random effects in \code{formula_rhs}.
Feature-wise models can be evaluated in parallel using \code{future::plan()},
with optional progress updates via \code{progressr::with_progress()}.
}
\examples{
mock_X <- matrix(
  rnorm(50 * 10) +
    rep(c(rep(0, 25), rep(2, 25)), each = 10) * rep(1:10 \%in\% 1:3, each = 50),
  nrow = 50
)

rownames(mock_X) <- paste0("sample", 1:50)
colnames(mock_X) <- paste0("feat", 1:10)

sample_data <- data.frame(
  sample_id = rownames(mock_X),
  group = factor(rep(c("A", "B"), each = 25)),
  subject = factor(rep(1:25, each = 2)),
  row.names = rownames(mock_X)
)

# Example with parallel computation setup (not run)
# future::plan(multisession)
# progressr::handlers(global = TRUE)
# progressr::with_progress({
  result <- dana(X = mock_X,
                 sample_data = sample_data,
                 formula_rhs = ~ group + (1 | subject),
                 term_LRT = c("group", "1 | subject"), # Multiple terms allowed
                 platform = "ms",
                 assay = "lipidomics",
                 verbose = FALSE
                 )
# })

# Modify `dana` object at once with pipes (not run)
# dana_obj <- dana_obj |> adjust_pval() |> add_feat_name() |> ready_plots()

}
\seealso{
\code{\link[stats:lm]{stats::lm()}}, \code{\link[lme4:lmer]{lme4::lmer()}}, \code{\link[lmerTest:lmer]{lmerTest::lmer()}} parameters.
}
