library(rearrr)
context("swirl_3d()")


test_that("fuzz testing swirl_3d()", {
  xpectr::set_test_seed(42)

  # Create a data frame
  df <- data.frame(
    "x" = runif(15),
    "y" = runif(15),
    "z" = runif(15),
    "g" = rep(c(1, 2, 3, 4, 5), each = 3),
    stringsAsFactors = FALSE
  ) %>%
    dplyr::as_tibble()


  # Generate expectations for 'swirl_3d'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = swirl_3d,
  #   args_values = list(
  #     "data" = list(df, dplyr::group_by(df, g), c(1, 2, 3, 4, 5), "hej", NA),
  #     "x_col" = list("x", "y", NA),
  #     "y_col" = list("y", "x", NA),
  #     "z_col" = list("z", "x", NA),
  #     "x_radius" = list(1, 0, -1, 10, c(1, 2, 3), NA),
  #     "y_radius" = list(1, 0, -1, 10, NA),
  #     "z_radius" = list(1, 0, -1, 10, NA),
  #     "suffix" = list("", "_swirled", NA),
  #     "origin" = list(c(0, 0, 0), c(NA, 0, 0), c(0, 0), NA),
  #     "origin_fn" = list(NULL, centroid),
  #     "scale_fn" = list(identity, function(d){d^1.5}, function(d){c(d, d+1)}),
  #     "keep_original" = list(FALSE),
  #     "degrees_col_name" = list(".degrees", ".deg"),
  #     "radius_col_name" = list(".radius", ".rad"),
  #     "origin_col_name" = list(".origin", ".origi"),
  #     "overwrite" = list(TRUE, FALSE)
  #   ),
  #   extra_combinations = list(
  #     list("data" = dplyr::group_by(df, g), "x_radius" = 1, "origin_fn" = centroid),
  #     list("origin_fn" = centroid, "origin" = NULL),
  #     list("keep_original" = TRUE, "suffix" = "_rotated"),
  #     list("overwrite" = FALSE, "radius_col_name" = "g"),
  #     list("degrees_col_name" = "popop", "radius_col_name" = "popop")
  #   ),
  #   indentation = 2
  # )



  ## Testing 'swirl_3d'                                                       ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["x"]],
    c(0.38815, 0.39382, 0.66675, 0.63873, 0.8652, 0.82967, 0.05858,
      0.25382, -0.12339, 0.20431, -0.44586, -0.15173, 0.6947, 0.76605,
      1.22943),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    c(0.12081, -0.24881, 0.28581, 0.24179, 0.28992, 0.03882, 0.9798,
      0.80877, 0.08569, 0.17669, 0.23139, -0.81405, -1.04144, -0.93095,
      -0.67546),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["z"]],
    c(-0.2847, -0.58725, -0.30294, -0.5093, 0.16328, 0.43396, 0.27519,
      0.61684, 1.09098, 1.14532, 1.20127, 1.04632, 0.76324, 0.90058,
      0.72464),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".radius_str"]],
    c("x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("x", "y", "z", ".origin", ".degrees", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "numeric", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "double", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = dplyr::group_by(df, g), x_co...
  # Changed from baseline: data = dplyr::group_b...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- swirl_3d(data = dplyr::group_by(df, g), x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19370),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19370[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["x"]],
    c(0.38815, 0.76605, 1.22943, 0.63873, 0.20431, -0.15173, 0.39382,
      0.05858, 0.6947, 0.66675, 0.8652, 0.82967, 0.25382, -0.12339,
      -0.44586),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["y"]],
    c(0.12081, -0.93095, -0.67546, 0.24179, 0.17669, -0.81405, -0.24881,
      0.9798, -1.04144, 0.28581, 0.28992, 0.03882, 0.80877, 0.08569,
      0.23139),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["z"]],
    c(-0.2847, 0.90058, 0.72464, -0.5093, 1.14532, 1.04632, -0.58725,
      0.27519, 0.76324, -0.30294, 0.16328, 0.43396, 0.61684, 1.09098,
      1.20127),
    tolerance = 1e-4)
  expect_equal(
    output_19370[[".radius_str"]],
    c("x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19370),
    c("g", "x", "y", "z", ".origin", ".degrees", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19370),
    c("numeric", "numeric", "numeric", "numeric", "list", "list", "list",
      "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19370),
    c("double", "double", "double", "double", "list", "list", "list",
      "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    c(15L, 8L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19370)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = c(1, 2, 3, 4, 5), x_col = "x...
  # Changed from baseline: data = c(1, 2, 3, 4, 5)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(swirl_3d(data = c(1, 2, 3, 4, 5), x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = "hej", x_col = "x", y_col = ...
  # Changed from baseline: data = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(swirl_3d(data = "hej", x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = NA, x_col = "x", y_col = "y"...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(swirl_3d(data = NA, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = NULL, x_col = "x", y_col = "...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(swirl_3d(data = NULL, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = dplyr::group_by(df, g), x_co...
  # Changed from baseline: data, x_radius, origi...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(swirl_3d(data = dplyr::group_by(df, g), x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = centroid, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['warnings']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['messages']]),
    xpectr::strip("When 'origin_fn' is specified, 'origin' is ignored.\n"),
    fixed = TRUE)
  # Assigning output
  output_17365 <- xpectr::suppress_mw(swirl_3d(data = dplyr::group_by(df, g), x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = centroid, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE))
  # Testing class
  expect_equal(
    class(output_17365),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17365[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["x"]],
    c(0.83453, 0.89209, 0.19694, 0.90394, 0.98313, 0.16034, 0.34305,
      1.05996, 0.19591, 0.67631, 0.44393, 0.80623, 0.42901, 0.16006,
      0.97085),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["y"]],
    c(0.99556, 1.02584, 0.37515, 0.5597, 0.87171, 0.56115, 0.99649,
      0.89666, 0.06622, 0.42457, 0.41594, 0.13845, 0.79988, 0.76269,
      0.60102),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["z"]],
    c(0.59717, 0.52414, 1.09836, 0.35376, 0.70868, 0.53175, 0.74239,
      0.21412, 0.32613, 0.42846, 0.65212, 0.34522, 0.52334, 0.01049,
      0.94655),
    tolerance = 1e-4)
  expect_equal(
    output_17365[[".radius_str"]],
    c("x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_17365),
    c("g", "x", "y", "z", ".origin", ".degrees", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("numeric", "numeric", "numeric", "numeric", "list", "list", "list",
      "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("double", "double", "double", "double", "list", "list", "list",
      "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    c(15L, 8L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "y", y_col = "y"...
  # Changed from baseline: x_col = "y"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "y", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'c(x_col, y_col, z_col)': Contains duplicated values, position 2."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = NA, y_col = "y",...
  # Changed from baseline: x_col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = NA, y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = NULL, y_col = "y...
  # Changed from baseline: x_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = NULL, y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "x"...
  # Changed from baseline: y_col = "x"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "x", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'c(x_col, y_col, z_col)': Contains duplicated values, position 2."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = NA,...
  # Changed from baseline: y_col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = NA, z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = NUL...
  # Changed from baseline: y_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = NULL, z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: z_col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = NA, x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'z_col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: z_col = "x"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "x", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'c(x_col, y_col, z_col)': Contains duplicated values, position 3."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: z_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = NULL, x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'z_col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: x_radius = 0
  xpectr::set_test_seed(42)
  # Assigning output
  output_19782 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 0, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19782),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19782[["x"]],
    c(-0.11292, 0.26542, -0.2246, 0.25975, 0.49668, 0.54398, 0.207,
      0.64277, 0.65952, 1.157, 1.07108, 1.27202, 1.04426, 0.9289,
      0.81187),
    tolerance = 1e-4)
  expect_equal(
    output_19782[["y"]],
    c(0.39276, -0.46257, -0.47838, -0.75727, -0.51669, -0.19296, -0.9781,
      -0.74736, -0.25337, 0.15878, -0.06033, 0.4014, 0.86533, 0.73781,
      0.77938),
    tolerance = 1e-4)
  expect_equal(
    output_19782[["z"]],
    c(-0.2816, -0.52673, -0.58199, -0.29136, -0.58789, -0.73827, -0.19907,
      -0.35684, -0.84478, -0.14446, 0.73791, 0.03622, 0.55721, 0.92592,
      1.10738),
    tolerance = 1e-4)
  expect_equal(
    output_19782[[".radius_str"]],
    c("x=0,y=1,z=1", "x=0,y=1,z=1", "x=0,y=1,z=1", "x=0,y=1,z=1", "x=0,y=1,z=1",
      "x=0,y=1,z=1", "x=0,y=1,z=1", "x=0,y=1,z=1", "x=0,y=1,z=1",
      "x=0,y=1,z=1", "x=0,y=1,z=1", "x=0,y=1,z=1", "x=0,y=1,z=1",
      "x=0,y=1,z=1", "x=0,y=1,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19782),
    c("x", "y", "z", ".origin", ".degrees", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19782),
    c("numeric", "numeric", "numeric", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19782),
    c("double", "double", "double", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19782),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19782)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: x_radius = -1
  xpectr::set_test_seed(42)
  # Assigning output
  output_11174 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = -1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_11174),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11174[["x"]],
    c(-0.3907, 0.48468, 0.68448, 0.83864, 0.85942, 0.78877, 0.06436,
      0.27189, -0.23084, 0.04783, 0.20184, -0.72894, -0.89973, -0.73738,
      -0.74609),
    tolerance = 1e-4)
  expect_equal(
    output_11174[["y"]],
    c(-0.10508, -0.35463, -0.33204, 0.13751, 0.08773, -0.19791, 1.00549,
      0.9437, 0.69158, 0.92972, 1.2396, 1.08545, 1.01117, 0.926, 0.72144),
    tolerance = 1e-4)
  expect_equal(
    output_11174[["z"]],
    c(-0.28744, -0.44854, 0.19808, -0.06006, 0.33611, 0.46569, 0.15499,
      0.36678, 0.82537, 0.71976, 0.34356, 0.2663, 0.56371, 0.92916,
      1.18984),
    tolerance = 1e-4)
  expect_equal(
    output_11174[[".radius_str"]],
    c("x=-1,y=1,z=1", "x=-1,y=1,z=1", "x=-1,y=1,z=1", "x=-1,y=1,z=1",
      "x=-1,y=1,z=1", "x=-1,y=1,z=1", "x=-1,y=1,z=1", "x=-1,y=1,z=1",
      "x=-1,y=1,z=1", "x=-1,y=1,z=1", "x=-1,y=1,z=1", "x=-1,y=1,z=1",
      "x=-1,y=1,z=1", "x=-1,y=1,z=1", "x=-1,y=1,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_11174),
    c("x", "y", "z", ".origin", ".degrees", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11174),
    c("numeric", "numeric", "numeric", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11174),
    c("double", "double", "double", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11174),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11174)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: x_radius = 10
  xpectr::set_test_seed(42)
  # Assigning output
  output_14749 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 10, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14749),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14749[["x"]],
    c(-0.05108, 0.25326, -0.21276, 0.20982, 0.50812, 0.57998, 0.21824,
      0.65181, 0.57585, 1.06572, 1.16736, 1.03761, 0.57982, 0.48471,
      0.23591),
    tolerance = 1e-4)
  expect_equal(
    output_14749[["y"]],
    c(0.40557, -0.44253, -0.34931, -0.70873, -0.37401, -0.01551, -0.86155,
      -0.55925, 0.09454, 0.43125, 0.22784, 0.8316, 1.24114, 1.07818,
      1.00148),
    tolerance = 1e-4)
  expect_equal(
    output_14749[["z"]],
    c(-0.28144, -0.54944, -0.67136, -0.42368, -0.67912, -0.73591, -0.49927,
      -0.60117, -0.93395, -0.25096, 0.52985, -0.11089, 0.52262, 0.93119,
      1.19759),
    tolerance = 1e-4)
  expect_equal(
    output_14749[[".radius_str"]],
    c("x=10,y=1,z=1", "x=10,y=1,z=1", "x=10,y=1,z=1", "x=10,y=1,z=1",
      "x=10,y=1,z=1", "x=10,y=1,z=1", "x=10,y=1,z=1", "x=10,y=1,z=1",
      "x=10,y=1,z=1", "x=10,y=1,z=1", "x=10,y=1,z=1", "x=10,y=1,z=1",
      "x=10,y=1,z=1", "x=10,y=1,z=1", "x=10,y=1,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_14749),
    c("x", "y", "z", ".origin", ".degrees", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14749),
    c("numeric", "numeric", "numeric", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14749),
    c("double", "double", "double", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14749),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14749)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: x_radius = c(1, 2, 3)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15603 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = c(1, 2, 3), y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error']]),
    xpectr::strip("1 assertions failed:\n * 'x_radius', 'y_radius', and 'z_radius' must all have the same length but had lengths: 3, 1, 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: x_radius = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19040 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = NA, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_radius': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: x_radius = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11387 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = NULL, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_radius': Must be of type 'numeric', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: y_radius = 0
  xpectr::set_test_seed(42)
  # Assigning output
  output_19888 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 0, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19888),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19888[["x"]],
    c(0.39002, -0.44711, 0.03932, -0.34816, -0.59132, -0.65192, -0.19375,
      -0.57212, -0.28015, -0.72806, -0.94859, -0.02114, 0.72702, 0.76563,
      1.2247),
    tolerance = 1e-4)
  expect_equal(
    output_19888[["y"]],
    c(0.28162, 0.59438, 0.78481, 0.73703, 0.63006, 0.33539, 0.9644,
      0.68235, 0.03407, -0.40171, -0.47009, -0.58619, -0.7382, -0.90327,
      -0.65676),
    tolerance = 1e-4)
  expect_equal(
    output_19888[["z"]],
    c(0.122, 0.09304, 0.02301, 0.24779, -0.33562, -0.5837, -0.26749,
      -0.55327, -1.0645, -0.83263, -0.758, -1.19851, -1.03742, -0.92869,
      -0.74942),
    tolerance = 1e-4)
  expect_equal(
    output_19888[[".radius_str"]],
    c("x=1,y=0,z=1", "x=1,y=0,z=1", "x=1,y=0,z=1", "x=1,y=0,z=1", "x=1,y=0,z=1",
      "x=1,y=0,z=1", "x=1,y=0,z=1", "x=1,y=0,z=1", "x=1,y=0,z=1",
      "x=1,y=0,z=1", "x=1,y=0,z=1", "x=1,y=0,z=1", "x=1,y=0,z=1",
      "x=1,y=0,z=1", "x=1,y=0,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19888),
    c("x", "y", "z", ".origin", ".degrees", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19888),
    c("numeric", "numeric", "numeric", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19888),
    c("double", "double", "double", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19888),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19888)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: y_radius = -1
  xpectr::set_test_seed(42)
  # Assigning output
  output_19466 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = -1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19466),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19466[["x"]],
    c(0.38531, 0.48685, 0.68917, 0.8374, 0.71655, 0.605, 0.09109, 0.41931,
      0.50918, 0.95028, 0.27194, 0.88237, 0.91336, 0.73781, 0.87304),
    tolerance = 1e-4)
  expect_equal(
    output_19466[["y"]],
    c(-0.12315, -0.3421, 0.26797, 0.1421, 0.32463, 0.08379, 0.98178,
      0.8341, 0.29403, 0.63946, 1.23296, 0.99031, 1.0101, 0.926, 0.73322),
    tolerance = 1e-4)
  expect_equal(
    output_19466[["z"]],
    c(0.28754, 0.45585, 0.26691, 0.06636, 0.49036, 0.71073, 0.25879,
      0.47695, 0.93117, 0.26977, -0.31816, 0.14557, -0.54334, -0.92882,
      -1.09226),
    tolerance = 1e-4)
  expect_equal(
    output_19466[[".radius_str"]],
    c("x=1,y=-1,z=1", "x=1,y=-1,z=1", "x=1,y=-1,z=1", "x=1,y=-1,z=1",
      "x=1,y=-1,z=1", "x=1,y=-1,z=1", "x=1,y=-1,z=1", "x=1,y=-1,z=1",
      "x=1,y=-1,z=1", "x=1,y=-1,z=1", "x=1,y=-1,z=1", "x=1,y=-1,z=1",
      "x=1,y=-1,z=1", "x=1,y=-1,z=1", "x=1,y=-1,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19466),
    c("x", "y", "z", ".origin", ".degrees", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19466),
    c("numeric", "numeric", "numeric", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19466),
    c("double", "double", "double", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19466),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19466)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: y_radius = 10
  xpectr::set_test_seed(42)
  # Assigning output
  output_10824 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 10, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_10824),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_10824[["x"]],
    c(0.3902, -0.44809, 0.04578, -0.38631, -0.468, -0.45609, -0.10286,
      -0.37068, 0.0771, -0.42474, -0.72804, 0.24377, 0.78315, 0.75767,
      1.10952),
    tolerance = 1e-4)
  expect_equal(
    output_10824[["y"]],
    c(0.29709, 0.59536, 0.77967, 0.75617, 0.60126, 0.29619, 0.96995,
      0.71319, 0.15173, -0.21354, -0.16236, -0.12395, -0.21157, -0.38011,
      -0.2015),
    tolerance = 1e-4)
  expect_equal(
    output_10824[["z"]],
    c(0.07609, -0.08139, -0.08959, 0.06925, -0.52795, -0.76317, -0.29628,
      -0.67305, -1.08804, -1.07644, -1.06722, -1.30602, -1.22133,
      -1.24338, -1.10509),
    tolerance = 1e-4)
  expect_equal(
    output_10824[[".radius_str"]],
    c("x=1,y=10,z=1", "x=1,y=10,z=1", "x=1,y=10,z=1", "x=1,y=10,z=1",
      "x=1,y=10,z=1", "x=1,y=10,z=1", "x=1,y=10,z=1", "x=1,y=10,z=1",
      "x=1,y=10,z=1", "x=1,y=10,z=1", "x=1,y=10,z=1", "x=1,y=10,z=1",
      "x=1,y=10,z=1", "x=1,y=10,z=1", "x=1,y=10,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_10824),
    c("x", "y", "z", ".origin", ".degrees", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_10824),
    c("numeric", "numeric", "numeric", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_10824),
    c("double", "double", "double", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_10824),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_10824)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: y_radius = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15142 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = NA, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_radius': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: y_radius = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13902 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = NULL, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13902[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_radius': Must be of type 'numeric', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13902[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: z_radius = 0
  xpectr::set_test_seed(42)
  # Assigning output
  output_19057 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19057),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19057[["x"]],
    c(0.12532, -0.45427, -0.34393, -0.46244, -0.77659, -0.80592, -0.11813,
      -0.37326, 0.09039, -0.26676, 0.07165, 0.78173, 0.96195, 0.94249,
      0.95637),
    tolerance = 1e-4)
  expect_equal(
    output_19057[["y"]],
    c(-0.38671, -0.10314, -0.63871, -0.50258, -0.47908, -0.20091, -0.97441,
      -0.76106, -0.11999, -0.04244, -0.49719, 0.27313, 0.80116, 0.7518,
      1.02621),
    tolerance = 1e-4)
  expect_equal(
    output_19057[["z"]],
    c(-0.2847, -0.58725, -0.30294, -0.5093, 0.16328, 0.43396, 0.27519,
      0.61684, 1.09098, 1.14532, 1.20127, 1.04632, 0.76324, 0.90058,
      0.72464),
    tolerance = 1e-4)
  expect_equal(
    output_19057[[".radius_str"]],
    c("x=1,y=1,z=0", "x=1,y=1,z=0", "x=1,y=1,z=0", "x=1,y=1,z=0", "x=1,y=1,z=0",
      "x=1,y=1,z=0", "x=1,y=1,z=0", "x=1,y=1,z=0", "x=1,y=1,z=0",
      "x=1,y=1,z=0", "x=1,y=1,z=0", "x=1,y=1,z=0", "x=1,y=1,z=0",
      "x=1,y=1,z=0", "x=1,y=1,z=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19057),
    c("x", "y", "z", ".origin", ".degrees", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19057),
    c("numeric", "numeric", "numeric", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19057),
    c("double", "double", "double", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19057),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19057)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: z_radius = -1
  xpectr::set_test_seed(42)
  # Assigning output
  output_14469 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = -1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14469),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14469[["x"]],
    c(-0.38523, 0.24775, -0.12839, 0.1879, 0.6473, 0.75081, 0.17724,
      0.48411, -0.04832, 0.24906, 0.36239, -0.62568, -0.8986, -0.73739,
      -0.7603),
    tolerance = 1e-4)
  expect_equal(
    output_14469[["y"]],
    c(-0.12982, 0.39448, 0.71397, 0.65661, 0.64314, 0.35518, 0.96541,
      0.69582, 0.14225, -0.10456, 0.34786, 0.54243, 0.87162, 0.95382,
      1.17885),
    tolerance = 1e-4)
  expect_equal(
    output_14469[["z"]],
    c(-0.2847, -0.58725, -0.30294, -0.5093, 0.16328, 0.43396, 0.27519,
      0.61684, 1.09098, 1.14532, 1.20127, 1.04632, 0.76324, 0.90058,
      0.72464),
    tolerance = 1e-4)
  expect_equal(
    output_14469[[".radius_str"]],
    c("x=1,y=1,z=-1", "x=1,y=1,z=-1", "x=1,y=1,z=-1", "x=1,y=1,z=-1",
      "x=1,y=1,z=-1", "x=1,y=1,z=-1", "x=1,y=1,z=-1", "x=1,y=1,z=-1",
      "x=1,y=1,z=-1", "x=1,y=1,z=-1", "x=1,y=1,z=-1", "x=1,y=1,z=-1",
      "x=1,y=1,z=-1", "x=1,y=1,z=-1", "x=1,y=1,z=-1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_14469),
    c("x", "y", "z", ".origin", ".degrees", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14469),
    c("numeric", "numeric", "numeric", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14469),
    c("double", "double", "double", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14469),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14469)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: z_radius = 10
  xpectr::set_test_seed(42)
  # Assigning output
  output_18360 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 10, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_18360),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_18360[["x"]],
    c(0.18385, -0.41767, -0.17735, -0.31306, -0.60634, -0.71294, 0.19463,
      -0.10706, 0.12573, -0.2334, 0.26349, 0.60287, 0.50557, 0.49679,
      0.35271),
    tolerance = 1e-4)
  expect_equal(
    output_18360[["y"]],
    c(-0.36256, -0.20628, -0.70341, -0.60699, -0.68188, -0.42612, -0.96206,
      -0.84088, -0.08223, -0.13596, -0.42767, 0.56767, 1.14525, 1.0985,
      1.35769),
    tolerance = 1e-4)
  expect_equal(
    output_18360[["z"]],
    c(-0.2847, -0.58725, -0.30294, -0.5093, 0.16328, 0.43396, 0.27519,
      0.61684, 1.09098, 1.14532, 1.20127, 1.04632, 0.76324, 0.90058,
      0.72464),
    tolerance = 1e-4)
  expect_equal(
    output_18360[[".radius_str"]],
    c("x=1,y=1,z=10", "x=1,y=1,z=10", "x=1,y=1,z=10", "x=1,y=1,z=10",
      "x=1,y=1,z=10", "x=1,y=1,z=10", "x=1,y=1,z=10", "x=1,y=1,z=10",
      "x=1,y=1,z=10", "x=1,y=1,z=10", "x=1,y=1,z=10", "x=1,y=1,z=10",
      "x=1,y=1,z=10", "x=1,y=1,z=10", "x=1,y=1,z=10"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_18360),
    c("x", "y", "z", ".origin", ".degrees", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_18360),
    c("numeric", "numeric", "numeric", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_18360),
    c("double", "double", "double", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_18360),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_18360)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: z_radius = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17375 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = NA, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'z_radius': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: z_radius = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18110 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'z_radius': Must be of type 'numeric', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: suffix = "_swirled"
  xpectr::set_test_seed(42)
  # Assigning output
  output_13881 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "_swirled", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_13881),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13881[["x_swirled"]],
    c(0.38815, 0.39382, 0.66675, 0.63873, 0.8652, 0.82967, 0.05858,
      0.25382, -0.12339, 0.20431, -0.44586, -0.15173, 0.6947, 0.76605,
      1.22943),
    tolerance = 1e-4)
  expect_equal(
    output_13881[["y_swirled"]],
    c(0.12081, -0.24881, 0.28581, 0.24179, 0.28992, 0.03882, 0.9798,
      0.80877, 0.08569, 0.17669, 0.23139, -0.81405, -1.04144, -0.93095,
      -0.67546),
    tolerance = 1e-4)
  expect_equal(
    output_13881[["z_swirled"]],
    c(-0.2847, -0.58725, -0.30294, -0.5093, 0.16328, 0.43396, 0.27519,
      0.61684, 1.09098, 1.14532, 1.20127, 1.04632, 0.76324, 0.90058,
      0.72464),
    tolerance = 1e-4)
  expect_equal(
    output_13881[[".radius_str"]],
    c("x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_13881),
    c("x_swirled", "y_swirled", "z_swirled", ".origin", ".degrees",
      ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13881),
    c("numeric", "numeric", "numeric", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13881),
    c("double", "double", "double", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13881),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13881)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: suffix = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16851 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = NA, origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: suffix = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10039 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = NULL, origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10039[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10039[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: suffix, keep_original
  xpectr::set_test_seed(42)
  # Assigning output
  output_18329 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "_rotated", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = TRUE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_18329),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_18329[["x"]],
    c(0.28614, 0.73659, 0.45774, 0.64175, 0.71911, 0.70506, 0.13467,
      0.46229, 0.25543, 0.83045, 0.93467, 0.5191, 0.65699, 0.91481,
      0.93708),
    tolerance = 1e-4)
  expect_equal(
    output_18329[["y"]],
    c(0.11749, 0.13871, 0.51421, 0.56033, 0.3902, 0.08244, 0.98889,
      0.836, 0.44697, 0.475, 0.90574, 0.90403, 0.94667, 0.94001, 0.97823),
    tolerance = 1e-4)
  expect_equal(
    output_18329[["z"]],
    c(0.38811, 0.00733, 0.37956, 0.00395, 0.43577, 0.61178, 0.20766,
      0.43175, 0.97354, 0.68517, 0.03743, 0.83292, 0.9066, 0.7376,
      0.81106),
    tolerance = 1e-4)
  expect_equal(
    output_18329[["g"]],
    c(1, 3, 4, 2, 4, 4, 3, 5, 5, 2, 5, 2, 3, 1, 1),
    tolerance = 1e-4)
  expect_equal(
    output_18329[["x_rotated"]],
    c(0.38815, 0.39382, 0.66675, 0.63873, 0.8652, 0.82967, 0.05858,
      0.25382, -0.12339, 0.20431, -0.44586, -0.15173, 0.6947, 0.76605,
      1.22943),
    tolerance = 1e-4)
  expect_equal(
    output_18329[["y_rotated"]],
    c(0.12081, -0.24881, 0.28581, 0.24179, 0.28992, 0.03882, 0.9798,
      0.80877, 0.08569, 0.17669, 0.23139, -0.81405, -1.04144, -0.93095,
      -0.67546),
    tolerance = 1e-4)
  expect_equal(
    output_18329[["z_rotated"]],
    c(-0.2847, -0.58725, -0.30294, -0.5093, 0.16328, 0.43396, 0.27519,
      0.61684, 1.09098, 1.14532, 1.20127, 1.04632, 0.76324, 0.90058,
      0.72464),
    tolerance = 1e-4)
  expect_equal(
    output_18329[[".radius_str"]],
    c("x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_18329),
    c("x", "y", "z", "g", "x_rotated", "y_rotated", "z_rotated", ".origin",
      ".degrees", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_18329),
    c("numeric", "numeric", "numeric", "numeric", "numeric", "numeric",
      "numeric", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_18329),
    c("double", "double", "double", "double", "double", "double", "double",
      "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_18329),
    c(15L, 11L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_18329)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin = c(NA, 0, 0)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10073 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(NA, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10073[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10073[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin = c(0, 0)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12076 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12076[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Must have length 3, but has length 2."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12076[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19066 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = NA, origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19066[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Must have length 3, but has length 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19066[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16117 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = NULL, origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16117[['error']]),
    xpectr::strip("1 assertions failed:\n * At least one of {'origin', 'origin_fn'} must be specified (not 'NULL')."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16117[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin, origin_fn
  xpectr::set_test_seed(42)
  # Assigning output
  output_13795 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = NULL, origin_fn = centroid, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_13795),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13795[["x"]],
    c(0.44669, 0.64264, 0.46489, 0.86511, 0.94648, 0.12006, 0.85378,
      1.02319, 0.72917, 0.94913, 0.46235, 1.03351, 0.22087, 0.23144,
      0.15263),
    tolerance = 1e-4)
  expect_equal(
    output_13795[["y"]],
    c(0.47398, 0.48446, 0.73876, 0.5757, 0.88687, 0.56065, 0.93536,
      0.94142, 0.07478, 0.89222, 0.23978, 0.58989, 0.75241, 1.14251,
      0.0969),
    tolerance = 1e-4)
  expect_equal(
    output_13795[["z"]],
    c(0.47573, 0.27847, 0.69294, 0.30357, 0.63849, 0.46709, 0.18979,
      0.42589, 0.49521, 0.11465, 0.94678, 0.95022, 0.02069, 0.6647,
      0.45838),
    tolerance = 1e-4)
  expect_equal(
    output_13795[[".radius_str"]],
    c("x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_13795),
    c("x", "y", "z", ".origin", ".degrees", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13795),
    c("numeric", "numeric", "numeric", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13795),
    c("double", "double", "double", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13795),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13795)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin_fn = centroid
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14357 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = centroid, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14357[['warnings']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14357[['messages']]),
    xpectr::strip("When 'origin_fn' is specified, 'origin' is ignored.\n"),
    fixed = TRUE)
  # Assigning output
  output_14357 <- xpectr::suppress_mw(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = centroid, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE))
  # Testing class
  expect_equal(
    class(output_14357),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14357[["x"]],
    c(0.44669, 0.64264, 0.46489, 0.86511, 0.94648, 0.12006, 0.85378,
      1.02319, 0.72917, 0.94913, 0.46235, 1.03351, 0.22087, 0.23144,
      0.15263),
    tolerance = 1e-4)
  expect_equal(
    output_14357[["y"]],
    c(0.47398, 0.48446, 0.73876, 0.5757, 0.88687, 0.56065, 0.93536,
      0.94142, 0.07478, 0.89222, 0.23978, 0.58989, 0.75241, 1.14251,
      0.0969),
    tolerance = 1e-4)
  expect_equal(
    output_14357[["z"]],
    c(0.47573, 0.27847, 0.69294, 0.30357, 0.63849, 0.46709, 0.18979,
      0.42589, 0.49521, 0.11465, 0.94678, 0.95022, 0.02069, 0.6647,
      0.45838),
    tolerance = 1e-4)
  expect_equal(
    output_14357[[".radius_str"]],
    c("x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_14357),
    c("x", "y", "z", ".origin", ".degrees", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14357),
    c("numeric", "numeric", "numeric", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14357),
    c("double", "double", "double", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14357),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14357)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: scale_fn = function(d...
  xpectr::set_test_seed(42)
  # Assigning output
  output_10374 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = function(d) {
      d^1.5
  }, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_10374),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_10374[["x"]],
    c(0.43334, 0.16306, 0.55502, 0.49977, 0.89812, 0.87488, 0.01781,
      0.1387, -0.21497, 0.11454, -0.04173, 1.04509, 1.19174, 1.17467,
      0.94774),
    tolerance = 1e-4)
  expect_equal(
    output_10374[["y"]],
    c(0.206, -0.16939, 0.2679, 0.16659, 0.22781, 0.00346, 0.97141, 0.76722,
      -0.18564, -0.19955, -0.8628, -0.71977, 0.70372, 0.71038, 0.97131),
    tolerance = 1e-4)
  expect_equal(
    output_10374[["z"]],
    c(-0.12684, -0.71174, -0.48805, -0.66956, 0.02761, 0.33579, 0.30857,
      0.70083, 1.06402, 1.15403, 0.97427, 0.41256, 0.48403, 0.61648,
      0.80697),
    tolerance = 1e-4)
  expect_equal(
    output_10374[[".radius_str"]],
    c("x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_10374),
    c("x", "y", "z", ".origin", ".degrees", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_10374),
    c("numeric", "numeric", "numeric", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_10374),
    c("double", "double", "double", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_10374),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_10374)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: scale_fn = function(d...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19735 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = function(d) {
      c(d, d + 1)
  }, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19735[['error']]),
    xpectr::strip("the output of 'scale_fn' must have the same length as the input."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19735[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: scale_fn = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14317 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14317[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'scale_fn': Must be a function, not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14317[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: keep_original = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19575 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = NULL, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19575[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19575[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: degrees_col_name = "....
  xpectr::set_test_seed(42)
  # Assigning output
  output_18877 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".deg", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_18877),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_18877[["x"]],
    c(0.38815, 0.39382, 0.66675, 0.63873, 0.8652, 0.82967, 0.05858,
      0.25382, -0.12339, 0.20431, -0.44586, -0.15173, 0.6947, 0.76605,
      1.22943),
    tolerance = 1e-4)
  expect_equal(
    output_18877[["y"]],
    c(0.12081, -0.24881, 0.28581, 0.24179, 0.28992, 0.03882, 0.9798,
      0.80877, 0.08569, 0.17669, 0.23139, -0.81405, -1.04144, -0.93095,
      -0.67546),
    tolerance = 1e-4)
  expect_equal(
    output_18877[["z"]],
    c(-0.2847, -0.58725, -0.30294, -0.5093, 0.16328, 0.43396, 0.27519,
      0.61684, 1.09098, 1.14532, 1.20127, 1.04632, 0.76324, 0.90058,
      0.72464),
    tolerance = 1e-4)
  expect_equal(
    output_18877[[".radius_str"]],
    c("x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_18877),
    c("x", "y", "z", ".origin", ".deg", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_18877),
    c("numeric", "numeric", "numeric", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_18877),
    c("double", "double", "double", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_18877),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_18877)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: degrees_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_16399 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = NULL, radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_16399),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16399[["x"]],
    c(0.38815, 0.39382, 0.66675, 0.63873, 0.8652, 0.82967, 0.05858,
      0.25382, -0.12339, 0.20431, -0.44586, -0.15173, 0.6947, 0.76605,
      1.22943),
    tolerance = 1e-4)
  expect_equal(
    output_16399[["y"]],
    c(0.12081, -0.24881, 0.28581, 0.24179, 0.28992, 0.03882, 0.9798,
      0.80877, 0.08569, 0.17669, 0.23139, -0.81405, -1.04144, -0.93095,
      -0.67546),
    tolerance = 1e-4)
  expect_equal(
    output_16399[["z"]],
    c(-0.2847, -0.58725, -0.30294, -0.5093, 0.16328, 0.43396, 0.27519,
      0.61684, 1.09098, 1.14532, 1.20127, 1.04632, 0.76324, 0.90058,
      0.72464),
    tolerance = 1e-4)
  expect_equal(
    output_16399[[".radius_str"]],
    c("x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_16399),
    c("x", "y", "z", ".origin", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16399),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16399),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16399),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16399)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: degrees_col_name, rad...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19709 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = "popop", radius_col_name = "popop", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19709[['error']]),
    xpectr::strip("Assertion on 'specified column names (\"x\", \"y\", \"z\", \"popop\", ...)' failed: Contains duplicated values, position 6."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19709[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: radius_col_name = ".rad"
  xpectr::set_test_seed(42)
  # Assigning output
  output_16188 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".rad", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_16188),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16188[["x"]],
    c(0.38815, 0.39382, 0.66675, 0.63873, 0.8652, 0.82967, 0.05858,
      0.25382, -0.12339, 0.20431, -0.44586, -0.15173, 0.6947, 0.76605,
      1.22943),
    tolerance = 1e-4)
  expect_equal(
    output_16188[["y"]],
    c(0.12081, -0.24881, 0.28581, 0.24179, 0.28992, 0.03882, 0.9798,
      0.80877, 0.08569, 0.17669, 0.23139, -0.81405, -1.04144, -0.93095,
      -0.67546),
    tolerance = 1e-4)
  expect_equal(
    output_16188[["z"]],
    c(-0.2847, -0.58725, -0.30294, -0.5093, 0.16328, 0.43396, 0.27519,
      0.61684, 1.09098, 1.14532, 1.20127, 1.04632, 0.76324, 0.90058,
      0.72464),
    tolerance = 1e-4)
  expect_equal(
    output_16188[[".rad_str"]],
    c("x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_16188),
    c("x", "y", "z", ".origin", ".degrees", ".rad", ".rad_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16188),
    c("numeric", "numeric", "numeric", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16188),
    c("double", "double", "double", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16188),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16188)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: radius_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_13334 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = NULL, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_13334),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13334[["x"]],
    c(0.38815, 0.39382, 0.66675, 0.63873, 0.8652, 0.82967, 0.05858,
      0.25382, -0.12339, 0.20431, -0.44586, -0.15173, 0.6947, 0.76605,
      1.22943),
    tolerance = 1e-4)
  expect_equal(
    output_13334[["y"]],
    c(0.12081, -0.24881, 0.28581, 0.24179, 0.28992, 0.03882, 0.9798,
      0.80877, 0.08569, 0.17669, 0.23139, -0.81405, -1.04144, -0.93095,
      -0.67546),
    tolerance = 1e-4)
  expect_equal(
    output_13334[["z"]],
    c(-0.2847, -0.58725, -0.30294, -0.5093, 0.16328, 0.43396, 0.27519,
      0.61684, 1.09098, 1.14532, 1.20127, 1.04632, 0.76324, 0.90058,
      0.72464),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_13334),
    c("x", "y", "z", ".origin", ".degrees"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13334),
    c("numeric", "numeric", "numeric", "list", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13334),
    c("double", "double", "double", "list", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13334),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13334)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: radius_col_name, over...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13467 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = "g", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13467[['error']]),
    xpectr::strip("1 assertions failed:\n * The column 'g' already exists and 'overwrite' is disabled."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13467[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin_col_name = ".o...
  xpectr::set_test_seed(42)
  # Assigning output
  output_13984 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origi", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_13984),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13984[["x"]],
    c(0.38815, 0.39382, 0.66675, 0.63873, 0.8652, 0.82967, 0.05858,
      0.25382, -0.12339, 0.20431, -0.44586, -0.15173, 0.6947, 0.76605,
      1.22943),
    tolerance = 1e-4)
  expect_equal(
    output_13984[["y"]],
    c(0.12081, -0.24881, 0.28581, 0.24179, 0.28992, 0.03882, 0.9798,
      0.80877, 0.08569, 0.17669, 0.23139, -0.81405, -1.04144, -0.93095,
      -0.67546),
    tolerance = 1e-4)
  expect_equal(
    output_13984[["z"]],
    c(-0.2847, -0.58725, -0.30294, -0.5093, 0.16328, 0.43396, 0.27519,
      0.61684, 1.09098, 1.14532, 1.20127, 1.04632, 0.76324, 0.90058,
      0.72464),
    tolerance = 1e-4)
  expect_equal(
    output_13984[[".radius_str"]],
    c("x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_13984),
    c("x", "y", "z", ".origi", ".degrees", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13984),
    c("numeric", "numeric", "numeric", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13984),
    c("double", "double", "double", "list", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13984),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13984)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_17846 <- swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17846),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17846[["x"]],
    c(0.38815, 0.39382, 0.66675, 0.63873, 0.8652, 0.82967, 0.05858,
      0.25382, -0.12339, 0.20431, -0.44586, -0.15173, 0.6947, 0.76605,
      1.22943),
    tolerance = 1e-4)
  expect_equal(
    output_17846[["y"]],
    c(0.12081, -0.24881, 0.28581, 0.24179, 0.28992, 0.03882, 0.9798,
      0.80877, 0.08569, 0.17669, 0.23139, -0.81405, -1.04144, -0.93095,
      -0.67546),
    tolerance = 1e-4)
  expect_equal(
    output_17846[["z"]],
    c(-0.2847, -0.58725, -0.30294, -0.5093, 0.16328, 0.43396, 0.27519,
      0.61684, 1.09098, 1.14532, 1.20127, 1.04632, 0.76324, 0.90058,
      0.72464),
    tolerance = 1e-4)
  expect_equal(
    output_17846[[".radius_str"]],
    c("x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1", "x=1,y=1,z=1",
      "x=1,y=1,z=1", "x=1,y=1,z=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_17846),
    c("x", "y", "z", ".degrees", ".radius", ".radius_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17846),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17846),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17846),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17846)),
    character(0),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: overwrite = FALSE
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10389 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10389[['error']]),
    xpectr::strip("Adding these dimensions would overwrite existing columns: x, y, z."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10389[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: overwrite = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17487 <- xpectr::capture_side_effects(swirl_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_radius = 1, y_radius = 1, z_radius = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17487[['error']]),
    xpectr::strip("Assertion on 'overwrite' failed: Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17487[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'swirl_3d'                                              ####
  #

})
