% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/min_max_scaler.R
\name{min_max_scale}
\alias{min_max_scale}
\title{Scale to a range}
\usage{
min_max_scale(
  x,
  new_min,
  new_max,
  old_min = NULL,
  old_max = NULL,
  na.rm = FALSE
)
}
\arguments{
\item{x}{Numeric \code{vector} to scale.}

\item{new_min}{Minimum value of target range.}

\item{new_max}{Maximum value of target range.}

\item{old_min}{Minimum value of original range.

If \code{NULL}, this is the minimum value in \code{`x`}.}

\item{old_max}{Maximum value of original range.

If \code{NULL}, this is the maximum value in \code{`x`}.}

\item{na.rm}{Whether missing values should be removed when calculating \code{`old_min`} and/or \code{`old_max`}.

\strong{N.B.} Ignored when both \code{`old_min`} and \code{`old_max`} are \code{NULL}.}
}
\value{
Scaled version of \code{`x`}.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Scales the values to a range with MinMax scaling.
}
\examples{
# Attach packages
library(rearrr)

# Set seed
set.seed(1)

# Create numeric vector
x <- runif(10)

# Scale
min_max_scale(x, new_min = -1, new_max = 0)
min_max_scale(x, new_min = -1, new_max = 0, old_max = 3)
}
\seealso{
Other scaling functions: 
\code{\link{to_unit_length}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{scaling functions}
