library(rearrr)
context("converters")

test_that("degrees_to_radians()", {

  expect_equal(degrees_to_radians(-720:720),
               (-720:720) * (pi/180))


  ## Testing 'degrees_to_radians(-720:720)'                                 ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- degrees_to_radians(-720:720)
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    xpectr::smpl(output_19148, n = 30),
    c(-10.54179, -9.65167, -9.19789, -9.14553, -6.21337, -5.39307, -2.93215,
      -1.55334, -1.13446, -1.06465, -0.7854, 0.13963, 0.43633, 1.32645,
      3.52557, 3.85718, 5.044, 5.37561, 5.88176, 8.02851, 8.27286,
      9.77384, 9.84366, 10.43707, 10.73377, 10.82104, 10.85595, 10.97812,
      11.74607, 11.9206),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(xpectr::smpl(output_19148, n = 30)),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    1441L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    1441L)
  ## Finished testing 'degrees_to_radians(-720:720)'                        ####


  # fuzz

  # Generate expectations for 'degrees_to_radians'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = degrees_to_radians,
  #   args_values = list(
  #     "degrees" = list(c(1,2,3, NA), c(1,2,3,4))
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'degrees_to_radians'                                             ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing degrees_to_radians(degrees = c(1, 2, 3, NA))
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- degrees_to_radians(degrees = c(1, 2, 3, NA))
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(0.01745, 0.03491, 0.05236, NA),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    4L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    4L)

  # Testing degrees_to_radians(degrees = c(1, 2, 3, 4))
  # Changed from baseline: degrees = c(1, 2, 3, 4)
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- degrees_to_radians(degrees = c(1, 2, 3, 4))
  # Testing class
  expect_equal(
    class(output_19370),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19370,
    type = "double")
  # Testing values
  expect_equal(
    output_19370,
    c(0.01745, 0.03491, 0.05236, 0.06981),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19370),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19370),
    4L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19370)),
    4L)

  # Testing degrees_to_radians(degrees = NULL)
  # Changed from baseline: degrees = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(degrees_to_radians(degrees = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("Assertion on 'degrees' failed: Must be of type 'numeric', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'degrees_to_radians'                                    ####
  #

})

test_that("degrees_to_radians()", {

  expect_equal(radians_to_degrees((-4*pi):(4*pi)),
               ((-4*pi):(4*pi)) / (pi/180))


  ## Testing 'radians_to_degrees((-4*pi):(4*pi))'                           ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- radians_to_degrees((-4*pi):(4*pi))
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(-720, -662.70422, -605.40844, -548.11266, -490.81688, -433.5211,
      -376.22532, -318.92954, -261.63376, -204.33798, -147.0422, -89.74643,
      -32.45065, 24.84513, 82.14091, 139.43669, 196.73247, 254.02825,
      311.32403, 368.61981, 425.91559, 483.21137, 540.50715, 597.80293,
      655.09871, 712.39449),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    26L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    26L)
  ## Finished testing 'radians_to_degrees((-4*pi):(4*pi))'                  ####


  # fuzz

  # Generate expectations for 'radians_to_degrees'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = radians_to_degrees,
  #   args_values = list(
  #     "radian" = list(c(1,2,3, NA), c(1,2,3,4))
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'radians_to_degrees'                                             ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing radians_to_degrees(radian = c(1, 2, 3, NA))
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- radians_to_degrees(radian = c(1, 2, 3, NA))
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(57.29578, 114.59156, 171.88734, NA),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    4L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    4L)

  # Testing radians_to_degrees(radian = c(1, 2, 3, 4))
  # Changed from baseline: radian = c(1, 2, 3, 4)
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- radians_to_degrees(radian = c(1, 2, 3, 4))
  # Testing class
  expect_equal(
    class(output_19370),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19370,
    type = "double")
  # Testing values
  expect_equal(
    output_19370,
    c(57.29578, 114.59156, 171.88734, 229.18312),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19370),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19370),
    4L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19370)),
    4L)

  # Testing radians_to_degrees(radian = NULL)
  # Changed from baseline: radian = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(radians_to_degrees(radian = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("Assertion on 'radians' failed: Must be of type 'numeric', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'radians_to_degrees'                                    ####
  #

})
