% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capture.R
\name{capture}
\alias{capture}
\alias{engroup}
\alias{group}
\alias{token}
\title{Capture a token, or not}
\usage{
capture(x)

group(x)

token(x)

engroup(x, capture)
}
\arguments{
\item{x}{A character vector.}

\item{capture}{Logical If \code{TRUE}, call \code{capture}; if \code{FALSE},
call \code{group}.}
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
Create a token to capture or not.
}
\examples{
x <- "foo"
capture(x)
group(x)

# Usage
# capture is good with match functions
(rx_price <- capture(digit(1, Inf) \%R\% DOT \%R\% digit(2)))
(rx_quantity <- capture(digit(1, Inf)))
(rx_all <- DOLLAR \%R\% rx_price \%R\% " for " \%R\% rx_quantity)
stringi::stri_match_first_regex("The price was $123.99 for 12.", rx_all)

# group is mostly used with alternation.  See ?or.
(rx_spread <- group("peanut butter" \%|\% "jam" \%|\% "marmalade"))
stringi::stri_extract_all_regex(
  "You can have peanut butter, jam, or marmalade on your toast.",
  rx_spread
)
}
\references{
\url{http://www.regular-expressions.info/brackets.html}
}
\seealso{
\code{\link{or}} for more examples
}

