% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relu.R
\name{step_relu}
\alias{step_relu}
\title{Apply (Smoothed) Rectified Linear Transformation}
\usage{
step_relu(recipe, ..., role = "predictor", trained = FALSE, shift = 0,
  reverse = FALSE, smooth = FALSE, prefix = "right_relu_", skip = FALSE)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables are
affected by the step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing
have been estimated.}

\item{shift}{A numeric value dictating a translation to apply to the data.}

\item{reverse}{A logical to indicate if the left hinge should be used as
opposed to the right hinge.}

\item{smooth}{A logical indicating if the softplus function, a smooth
appromixation to the rectified linear transformation, should be used.}

\item{prefix}{A prefix for generated column names, default to "right_relu_"
when right hinge transformation and "left_relu_" for reversed/left hinge
transformations.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}
}
\value{
An updated version of \code{recipe} with the
new step added to the sequence of existing steps (if any).
}
\description{
\code{step_relu} creates a \emph{specification} of a recipe step that
will apply the rectified linear or softplus transformations to numeric
data. The transformed data is added as new columns to the data matrix.
}
\details{
The rectified linear transformation is calculated as
\deqn{max(0, x - c)} and is also known as the ReLu or right hinge function.
If \code{reverse} is true, then the transformation is reflected about the
y-axis, like so: \deqn{max(0, c - x)} Setting the \code{smooth} option
to true will instead calculate a smooth approximation to ReLu
according to \deqn{ln(1 + e^(x - c)} The \code{reverse} argument may
also be applied to this transformation.
}
\section{Connection to MARS}{


The rectified linear transformation is used in the Multivariate Adaptive
Regression Splines as a basis function to fit piecewise linear functions to
data in a strategy similar to that employeed in tree based models. The
transformation is a popular choice as an activation function in many
neural networks, which could then be seen as a stacked generalization of
MARS when making use of ReLu activations. The hinge function also appears
in the loss function of Support Vector Machines, where it penalizes
residuals only if they are within a certain margin of the decision boundary.
}

\examples{
data(biomass)

biomass_tr <- biomass[biomass$dataset == "Training",]
biomass_te <- biomass[biomass$dataset == "Testing",]

rec <- recipe(HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
              data = biomass_tr)

transformed_te <- rec \%>\%
  step_relu(carbon, shift = 40) \%>\%
  prep(biomass_tr) \%>\%
  bake(biomass_te)

transformed_te

}
\seealso{
\code{\link[=recipe]{recipe()}} \code{\link[=prep.recipe]{prep.recipe()}}
\code{\link[=bake.recipe]{bake.recipe()}}
}
