% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale.R
\name{step_scale}
\alias{step_scale}
\alias{tidy.step_scale}
\title{Scaling Numeric Data}
\usage{
step_scale(recipe, ..., role = NA, trained = FALSE, sds = NULL,
  na_rm = TRUE, skip = FALSE, id = rand_id("scale"))

\method{tidy}{step_scale}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[=selections]{selections()}}
for more details. For the \code{tidy} method, these are not
currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{sds}{A named numeric vector of standard deviations This
is \code{NULL} until computed by \code{\link[=prep.recipe]{prep.recipe()}}.}

\item{na_rm}{A logical value indicating whether \code{NA}
values should be removed when computing the standard deviation.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_scale} object.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} (the
selectors or variables selected) and \code{value} (the
standard deviations).
}
\description{
\code{step_scale} creates a \emph{specification} of a recipe
step that will normalize numeric data to have a standard
deviation of one.
}
\details{
Scaling data means that the standard deviation of a
variable is divided out of the data. \code{step_scale} estimates
the variable standard deviations from the data used in the
\code{training} argument of \code{prep.recipe}.
\code{bake.recipe} then applies the scaling to new data sets
using these standard deviations.
}
\examples{
data(biomass)

biomass_tr <- biomass[biomass$dataset == "Training",]
biomass_te <- biomass[biomass$dataset == "Testing",]

rec <- recipe(HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
              data = biomass_tr)

scaled_trans <- rec \%>\%
  step_scale(carbon, hydrogen)

scaled_obj <- prep(scaled_trans, training = biomass_tr)

transformed_te <- bake(scaled_obj, biomass_te)

biomass_te[1:10, names(transformed_te)]
transformed_te
tidy(scaled_trans, number = 1)
tidy(scaled_obj, number = 1)

}
\concept{normalization_methods}
\concept{preprocessing}
\keyword{datagen}
