% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialsign.R
\name{step_spatialsign}
\alias{step_spatialsign}
\title{Spatial Sign Preprocessing}
\usage{
step_spatialsign(
  recipe,
  ...,
  role = "predictor",
  na_rm = TRUE,
  trained = FALSE,
  columns = NULL,
  skip = FALSE,
  id = rand_id("spatialsign")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from
the original variables will be used as \emph{predictors} in a model.}

\item{na_rm}{A logical: should missing data be removed from the
norm computation?}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_spatialsign} is a \emph{specification} of a recipe
step that will convert numeric data into a projection on to a
unit sphere.
}
\details{
The spatial sign transformation projects the variables
onto a unit sphere and is related to global contrast
normalization. The spatial sign of a vector \code{w} is
\code{w/norm(w)}.

The variables should be centered and scaled prior to the
computations.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with column
\code{terms} (the columns that will be affected) is returned.
}

\examples{
library(modeldata)
data(biomass)

biomass_tr <- biomass[biomass$dataset == "Training",]
biomass_te <- biomass[biomass$dataset == "Testing",]

rec <- recipe(HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
              data = biomass_tr)

ss_trans <- rec \%>\%
  step_center(carbon, hydrogen) \%>\%
  step_scale(carbon, hydrogen) \%>\%
  step_spatialsign(carbon, hydrogen)

ss_obj <- prep(ss_trans, training = biomass_tr)

transformed_te <- bake(ss_obj, biomass_te)

plot(biomass_te$carbon, biomass_te$hydrogen)

plot(transformed_te$carbon, transformed_te$hydrogen)

tidy(ss_trans, number = 3)
tidy(ss_obj, number = 3)
}
\references{
Serneels, S., De Nolf, E., and Van Espen, P.
(2006). Spatial sign preprocessing: a simple way to impart
moderate robustness to multivariate estimators. \emph{Journal of
Chemical Information and Modeling}, 46(3), 1402-1409.
}
\seealso{
Other multivariate transformation steps: 
\code{\link{step_classdist}()},
\code{\link{step_depth}()},
\code{\link{step_geodist}()},
\code{\link{step_ica}()},
\code{\link{step_isomap}()},
\code{\link{step_kpca_poly}()},
\code{\link{step_kpca_rbf}()},
\code{\link{step_kpca}()},
\code{\link{step_mutate_at}()},
\code{\link{step_nnmf_sparse}()},
\code{\link{step_nnmf}()},
\code{\link{step_pca}()},
\code{\link{step_pls}()},
\code{\link{step_ratio}()}
}
\concept{multivariate transformation steps}
