% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate_patterns.R
\name{tabulate_patterns}
\alias{tabulate_patterns}
\title{Create a table of comparison patterns}
\usage{
tabulate_patterns(pairs, ..., comparators = NULL, by = NULL)
}
\arguments{
\item{pairs}{a \code{pairs} object, such as generated by 
\code{\link{pair_blocking}}}

\item{...}{passed on to other methods.}

\item{comparators}{a list with comparison functions for each of the 
columns. When missing or \code{NULL}, \code{attr(pairs, "comparators")} is
used. Therefore, this parameter usually does not need to be specified.}

\item{by}{the columns that should be used for the comparison vectors. When
missing or \code{NULL}, \code{attr(pairs, "by")} is used. Therefore, this
parameter usually does not need to be specified.}
}
\value{
Returns a \code{data.frame} with all unique comparison patterns that exist
in \code{pairs}, with a column \code{n} added with the number of times each
pattern occurs.
}
\description{
Create a table of comparison patterns
}
\details{
Since comparison vectors can contain continuous numbers (usually between 0
and 1), this could result in a very large number of possible comparison 
vectors. Therefore, the comparison vectors are passed on to the comparators
in order to threshold them. This usually results in values 0 or 1. Missing
values are usually codes as 0. However, this all depends on the comparison
functions used. For more information see the documentation on the 
\link[=identical]{comparison functions}.
}
\examples{
data("linkexample1", "linkexample2")
pairs <- pair_blocking(linkexample1, linkexample2, "postcode")
pairs <- compare_pairs(pairs, c("lastname", "firstname", "address", "sex"))
tabulate_patterns(pairs)

}
