% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotorious.R
\name{read_annotorious}
\alias{read_annotorious}
\title{Parse annotorious annotations}
\usage{
read_annotorious(x, src = character())
}
\arguments{
\item{x}{a character string with json as returned by the htmlwidget}

\item{src}{a character string with the image src which was used in \code{x}}
}
\value{
a data.frame with annotations with columns: id, type, label, comment, x, y, width, height, polygon
and an attribute \code{src} with the provided \code{src}
}
\description{
Parse annotorious annotations
}
\examples{
url <- paste("https://upload.wikimedia.org/",
             "wikipedia/commons/a/a0/Pamphlet_dutch_tulipomania_1637.jpg",
             sep = "")
url <- system.file(package = "recogito", "examples", "Pamphlet_dutch_tulipomania_1637.jpg")
x <- '[
{
"type":"Annotation",
"body":[{"type":"TextualBody","value":"IMAGE","purpose":"tagging"}],
"target":{"selector":{
  "type":"FragmentSelector",
  "conformsTo":"http://www.w3.org/TR/media-frags/",
  "value":"xywh=pixel:41,249.5234375,371,245"}},
"@context":"http://www.w3.org/ns/anno.jsonld",
"id":"#58f0096c-4675-4ea8-9f38-bffce0887ab8"
},
{
"type":"Annotation",
"body":[{"type":"TextualBody","value":"TEXT","purpose":"tagging"}],
"target":{"selector":{
  "type":"FragmentSelector",
  "conformsTo":"http://www.w3.org/TR/media-frags/",
  "value":"xywh=pixel:46,5.523437976837158,371,239.99999952316284"}},
"@context":"http://www.w3.org/ns/anno.jsonld",
"id":"#50035dda-c62b-4f30-bf95-1879d60288a5"}]'
anno <- read_annotorious(x, src = url)
anno

\dontshow{
if(require(magick))
\{
}
library(magick)
img  <- image_read(url)
area <- head(anno, n = 1)
image_crop(img, geometry_area(x = area$x, y = area$y,
                              width = area$width, height = area$height))
area <- subset(anno, type == "RECTANGLE")
allrectangles <- Map(
  x      = area$x,
  y      = area$y,
  width  = area$width,
  height = area$height,
  f = function(x, y, width, height){
    image_crop(img, geometry_area(x = x, y = y, width = width, height = height))
})
allrectangles <- do.call(c, allrectangles)
allrectangles
\dontshow{
\}
}


x <- '[
{
  "type":"Annotation",
  "body":[{"type":"TextualBody","value":"IMAGE","purpose":"tagging"}],
  "target":{"selector":{
    "type":"FragmentSelector",
    "conformsTo":"http://www.w3.org/TR/media-frags/",
    "value":"xywh=pixel:43,244.5234375,362,252"
    }},
 "@context":"http://www.w3.org/ns/anno.jsonld",
 "id":"#4eaa8788-0c7e-42d2-b004-4d66b57018a1"},
{
  "type":"Annotation",
  "body":[{"type":"TextualBody","value":"TEXT","purpose":"tagging"}],
  "target":{"selector":{
    "type":"SvgSelector",
    "value":"<svg>
    <polygon points=\\\\\"75,4 75,58 32,95 32,194 410,195 391,70 373,63 368,3 222,1.5\\\\\">
    </polygon></svg>"}},
  "@context":"http://www.w3.org/ns/anno.jsonld",
  "id":"#8bf0a557-c847-4a07-91bc-68a98c499615"}]'
x    <- gsub(x, pattern = "\n", replacement = "")
anno <- read_annotorious(x, src = url)
anno
anno$polygon

\dontshow{
if(require(opencv))
\{
}
library(opencv)
img  <- ocv_read(url)
area <- subset(anno, type == "POLYGON")
ocv_polygon(img, pts = area$polygon[[1]])
\dontshow{
\}
}
}
