% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recordr.R
\docType{methods}
\name{startRecord}
\alias{startRecord}
\alias{startRecord,Recordr-method}
\title{Begin recording provenance for an R session.}
\usage{
startRecord(recordr, ...)

\S4method{startRecord}{Recordr}(recordr, tag = list(),
  .file = as.character(NA), .console = TRUE)
}
\arguments{
\item{recordr}{a Recordr instance}

\item{...}{additional parameters}

\item{tag}{a string that is associated with this run}

\item{.file}{the filename for the script to run (only used internally when startRecord() is called from record())}

\item{.console}{a logical argument that is used internally by the recordr package}
}
\value{
execution identifier that uniquely identifies this recorded session
}
\description{
This method starts the recording process and the method endRecord() completes it.
}
\details{
The startRecord() method can be called from the R console to begin a recording session
during which provenance is captured for any functions that are inspected by Recordr. This recordr
session can be closed by calling the endRecord() method. When the record() function is called to record
a script, the startRecord() function is called automatically.
}
\examples{
\dontrun{
rc <- new("Recordr")
startRecord(rc, tag="my first console run")
x <- read.csv(file="./test.csv")
runIdentifier <- endRecord(rc)
}
}
\seealso{
\code{\link[=Recordr-class]{Recordr}} { class description}
}

