% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateIntervalResidenceTime.R
\name{calculateIntervalResidenceTime}
\alias{calculateIntervalResidenceTime}
\title{Calculates residence time within user-specified breaks}
\usage{
calculateIntervalResidenceTime(x, breaks, labels = NULL)
}
\arguments{
\item{x}{\code{recurse} object returned from call to \code{\link{getRecursions}} or 
\code{\link{getRecursionsAtLocations}} with \code{verbose = TRUE}}

\item{breaks}{vector of POSIX datetimes describing the interval boundaries}

\item{labels}{(optional) vector or names for the intervals}
}
\value{
A matrix of residence times where the columns are the coordinate indices of the locations (either 
movement trajectory locations or user-specified locations) and the rows are the time intervals.
}
\description{
Using the results from \code{\link{getRecursions}} or \code{\link{getRecursionsAtLocations}},
calculates the residence time during user-specified intervals (rather than the entire trajectory period) in
the radius around each location.
}
\details{
When recursions are calculated, the residence time in the radius around each location is also 
calculated. This method allows the user to post-process the results from calculating recursions to calculate
residence time over user-specified intervals, rather than the entire trajectory. This allows the calculation
of residence time on biologically relevant scales, such as seasons, and in cases where large gaps between 
visits (e.g., a seasonal migrant) may make splitting up the residence time preferable.

Note that care should be taken to use the same time zone when specifying the break points as used in the
datetime for the movement trajectory.
}
\examples{
data(martin)
revisits = getRecursions(martin, radius = 1)
breaks = strptime(c("2000-01-01 00:00:00", "2000-01-15 00:00:00", "2000-02-01 00:00:00"), 
format = "")
intervalResTime = calculateIntervalResidenceTime(revisits, breaks)

}
\seealso{
\code{\link{getRecursions}}, \code{\link{getRecursionsAtLocations}}
}
\author{
Chloe Bracis <cbracis@uw.edu>
}
