% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraint_helpers.R
\name{flip_constraints_helper}
\alias{flip_constraints_helper}
\title{Flip Constraints Helper}
\usage{
flip_constraints_helper(
  map,
  constraint = "compact",
  constraintweight = 0.6,
  init_plan = NULL,
  compactness_metric = "edges-removed",
  areas,
  borderlength_mat,
  ssdmat,
  ssd_denom,
  counties = NULL,
  partisan_metric = "efficiency-gap",
  rvote,
  dvote,
  group_pop = NULL,
  target_min = 0.55,
  target_other = 0.25,
  minorityprop
)
}
\arguments{
\item{map}{A \code{\link{redist_map}} object.}

\item{constraint}{character vector of constraints to use. Current accepted are "compact",
"population", "countysplit", "hinge", "vra", "minority", "similarity", "partisan", and "segregation."
Defaults to compact.}

\item{constraintweight}{corresponding weights to use with constraint. Weights must be nonzero if provided. Defaults to
a weak compactness constraint}

\item{init_plan}{initial plan to use for the similarity constraint}

\item{compactness_metric}{character with "edges-removed", "polsby-popper", or "fryer-holden". Default is edges-removed.}

\item{areas}{areas to use with compact:polsby-popper. Computed from map if not provided and needed.}

\item{borderlength_mat}{border lengths to use with compact:polsby-popper.
Computed from map if not provided and needed.}

\item{ssdmat}{squared distance matrix to use with compact:fryer-holden. Computed from map if not provided and needed.}

\item{ssd_denom}{Denominator for compact:fryer-holden. Defaults to 1.0}

\item{counties}{tidy evaluated column with counties in map.}

\item{partisan_metric}{character with "proportional-representation" or "efficiency-gap"}

\item{rvote}{numeric vector of votes for Republicans. used with partisan constraint.}

\item{dvote}{numeric vector of votes for Democrats used with partisan constraint.}

\item{group_pop}{tidy evaluated column with group populations in map. Used with hinge, segregation, vra, and minority.}

\item{target_min}{numeric with higher minority target for vra. Defaults to 0.55.}

\item{target_other}{numeric with higher minority target for vra. Defaults to 0.25.}

\item{minorityprop}{minority proportions to target. Used by minority and hinge.Defaults to c(0.55) if none specified.}
}
\value{
list with an entry for each constraint usable with redist_flip()
}
\description{
Creates a constraints list for use with  \code{redist_flip}.
}
\examples{
data(iowa)
iowa_map <- redist_map(iowa, existing_plan = cd_2010, total_pop = pop, pop_tol = 0.01)
cons <- flip_constraints_helper(
  map = iowa_map, constraint = c('compact', 'vra'),
  constraintweight = c(0.05, 10), target_min = 0.05,
  target_other = 0.01, group_pop = black
)

redist_flip(iowa_map, 10, constraints = cons)

}
