% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_plans.R
\name{redist.plot.plans}
\alias{redist.plot.plans}
\title{Plot a district assignment}
\usage{
redist.plot.plans(plans, draws, geom, qty = NULL)
}
\arguments{
\item{plans}{a \code{redist_plans} object.}

\item{draws}{the plan(s) to plot. Will match the \code{draw} column of \code{x}.}

\item{geom}{the \code{redist_map} geometry to use}

\item{qty}{the quantity to plot. Defaults to the district assignment.}
}
\value{
A ggplot
}
\description{
Plot a district assignment
}
\examples{
library(dplyr)
data(iowa)

iowa = redist_map(iowa, existing_plan=cd_2010, pop_tol=0.05, total_pop = pop)
plans = redist_smc(iowa, nsims=100, silent=TRUE)
redist.plot.plans(plans, c(1, 2, 3, 4), iowa)

}
\concept{plot}
