% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flip_helpers.R
\name{redist.ipw}
\alias{redist.ipw}
\title{Inverse probability reweighting for MCMC Redistricting}
\usage{
redist.ipw(
  plans,
  resampleconstraint = c("pop_dev", "edges_removed", "segregation", "status_quo"),
  targetbeta,
  targetpop = NULL,
  temper = 0
)
}
\arguments{
\item{plans}{An object of class \code{redist_plans} from \code{redist_flip()}.}

\item{resampleconstraint}{The constraint implemented in the simulations: one
of "pop", "compact", "segregation", or "similar".}

\item{targetbeta}{The target value of the constraint.}

\item{targetpop}{The desired level of population parity. \code{targetpop} =
0.01 means that the desired distance from population parity is 1\%. The
default is \code{NULL}.}

\item{temper}{A flag for whether simulated tempering was used to improve the
mixing of the Markov Chain. The default is \code{1}.}
}
\value{
\code{redist.ipw} returns an object of class "redist". The object
\code{redist} is a list that contains the following components (the
inclusion of some components is dependent on whether tempering
techniques are used):
\item{plans}{Matrix of congressional district assignments generated by the
algorithm. Each row corresponds to a geographic unit, and each column
corresponds to a simulation.}
\item{distance_parity}{Vector containing the maximum distance from parity for
a particular simulated redistricting plan.}
\item{mhdecisions}{A vector specifying whether a proposed redistricting plan
was accepted (1) or rejected (0) in a given iteration.}
\item{mhprob}{A vector containing the Metropolis-Hastings acceptance
probability for each iteration of the algorithm.}
\item{pparam}{A vector containing the draw of the \code{p} parameter for each
simulation, which dictates the number of swaps attempted.}
\item{constraint_pop}{A vector containing the value of the population
constraint for each accepted redistricting plan.}
\item{constraint_compact}{A vector containing the value of the compactness
constraint for each accepted redistricting plan.}
\item{constraint_segregation}{A vector containing the value of the
segregation constraint for each accepted redistricting plan.}
\item{constraint_similar}{A vector containing the value of the similarity
constraint for each accepted redistricting plan.}
\item{constraint_vra}{A vector containing the value of the
vra constraint for each accepted redistricting plan.}
\item{constraint_partisan}{A vector containing the value of the
partisan constraint for each accepted redistricting plan.}
\item{constraint_minority}{A vector containing the value of the
minority constraint for each accepted redistricting plan.}
\item{constraint_hinge}{A vector containing the value of the
hinge constraint for each accepted redistricting plan.}
\item{constraint_qps}{A vector containing the value of the
QPS constraint for each accepted redistricting plan.}
\item{beta_sequence}{A vector containing the value of beta for each iteration
of the algorithm. Returned when tempering is being used.}
\item{mhdecisions_beta}{A vector specifying whether a proposed beta value was
accepted (1) or rejected (0) in a given iteration of the algorithm. Returned
when tempering is being used.}
\item{mhprob_beta}{A vector containing the Metropolis-Hastings acceptance
probability for each iteration of the algorithm. Returned when tempering
is being used.}
}
\description{
\code{redist.ipw} properly weights and resamples simulated redistricting plans
so that the set of simulated plans resemble a random sample from the
underlying distribution. \code{redist.ipw} is used to correct the sample when
population parity, geographic compactness, or other constraints are
implemented.
}
\details{
This function allows users to resample redistricting plans using
inverse probability weighting techniques described in Rubin (1987). This
techniques reweights and resamples redistricting plans so that the resulting
sample is representative of a random sample from the uniform distribution.
}
\examples{
\donttest{
data(iowa)
map_ia <- redist_map(iowa, existing_plan = cd_2010, pop_tol = 0.01)
cons <- redist_constr(map_ia)
cons <- add_constr_pop_dev(cons, strength = 5.4)
alg <- redist_flip(map_ia, nsims = 500, constraints = cons)

alg_ipw <- redist.ipw(plans = alg,
    resampleconstraint = "pop_dev",
    targetbeta = 1,
    targetpop = 0.05)
}

}
\references{
Fifield, Benjamin, Michael Higgins, Kosuke Imai and Alexander
Tarr. (2016) "A New Automated Redistricting Simulator Using Markov Chain
Monte Carlo." Working Paper.
Available at \url{http://imai.princeton.edu/research/files/redist.pdf}.

Rubin, Donald. (1987) "Comment: A Noniterative Sampling/Importance Resampling
Alternative to the Data Augmentation Algorithm for Creating a Few Imputations
when Fractions of Missing Information are Modest: the SIR Algorithm."
Journal of the American Statistical Association.
}
\concept{post}
