% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_overlap.R
\name{redist.prec.pop.overlap}
\alias{redist.prec.pop.overlap}
\title{Compare the Population Overlap Across Plans at the Precinct Level}
\usage{
redist.prec.pop.overlap(
  plan_old,
  plan_new,
  total_pop,
  weighting = "s",
  normalize = TRUE,
  index_only = FALSE,
  return_mat = FALSE
)
}
\arguments{
\item{plan_old}{The reference plan to compare against}

\item{plan_new}{The new plan to compare to the reference plan}

\item{total_pop}{The total population by precinct This can also take a redist_map
object and will use the population in that object. If nothing is provided, it weights
all entries in plan equally.}

\item{weighting}{Should weighting be done by sum of populations \code{'s'}, mean of
populations \code{'m'}, geometric mean of populations \code{'g'}, or none \code{'n'}}

\item{normalize}{Should entries be normalized by the total population}

\item{index_only}{Default is FALSE. TRUE returns only one numeric index, the
mean of the upper triangle of the matrix, under the weighting and normalization
chosen.}

\item{return_mat}{Defaults to FALSE, where it returns the summary by row. If
TRUE returns matrix with length(plan_old) rows and columns. Ignored if
index_only = TRUE.}
}
\value{
numeric vector with length(plan_old) entries
}
\description{
Compare the Population Overlap Across Plans at the Precinct Level
}
\examples{
set.seed(5)
data(iowa)
iowa_map <- redist_map(iowa, total_pop = pop, pop_tol = 0.01, ndists = 4)
plans <- redist_smc(iowa_map, 2, silent = TRUE)
plans_mat <- get_plans_matrix(plans)
ov_vec <- redist.prec.pop.overlap(plans_mat[, 1], plans_mat[, 2], iowa_map)
redist.prec.pop.overlap(plans_mat[, 1], plans_mat[, 2], iowa_map,  weighting = "s",
    normalize = FALSE, index_only = TRUE)

}
