% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_clean.R
\name{refdb_clean_tax_NA}
\alias{refdb_clean_tax_NA}
\title{Convert missing taxonomic names to NA}
\usage{
refdb_clean_tax_NA(x, cols = NULL, hybrid = TRUE, uncertain = FALSE)
}
\arguments{
\item{x}{a reference database.}

\item{cols}{an optional vector of column names.
If \code{NULL} (default), the function is applied to the columns
associated with the \code{taxonomy} and \code{organism} fields.}

\item{hybrid}{hybrids are converted to NA (default \code{TRUE}).}

\item{uncertain}{taxa with qualifiers of uncertainty (cf., aff., etc.)
are converted to NA (default \code{FALSE}).}
}
\value{
A reference database.
}
\description{
Convert missing taxonomic names to NA
}
\examples{
lib <- read.csv(system.file("extdata", "baetidae_bold.csv", package = "refdb"))
lib <- refdb_set_fields_BOLD(lib)
refdb_clean_tax_NA(lib)

}
