% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_merge.R
\name{refdb_merge}
\alias{refdb_merge}
\title{Merge reference databases}
\usage{
refdb_merge(..., keep = "fields_all")
}
\arguments{
\item{...}{reference databases (tibbles).}

\item{keep}{determines which columns to keep.
Can be \code{"fields_all"} (default), \code{"fields_shared"}
or \code{"all"} (see Details).}
}
\value{
a merged reference database (tibble).
}
\description{
Merge several reference database by common fields.
}
\details{
Columns are merged only if they are associated to the same field.

The \code{keep} argument determines which columns are returned as follow.
\code{"fields_all"} (the default) returns all the fields
existing in all the reference databases.
\code{"fields_shared"} returns only the fields shared by
all the reference databases.
\code{"all"} returns all the columns of all the databases.
Columns which are not associated to a field are not merged and are prefixed
with the name of the object they originated from.
}
\examples{
lib_1 <- read.csv(system.file("extdata", "baetidae_bold.csv", package = "refdb"))
lib_1 <- refdb_set_fields_BOLD(lib_1)
lib_2 <- lib_1
refdb_merge(lib_1, lib_2)

}
