#' SO2 and Nox concentrations
#'
#' The pollution dataset contains the SO2 and Nox concentrations in the As Pontes
#' thermal power plant surrondings, during a year. The data was analyzed from a
#' bivariate perspective in Roca--Pardiñas et al. (2021).
#'
#' @format A data frame with 6179 observations and 13 variables:
#' \describe{
#'   \item{Date}{The observation day, hour, and minute.}
#'   \item{So2}{So2 air concentration at the present time.}
#'   \item{Nox}{Nox air concentration at the present time.}
#'   \item{So2_0}{So2 air concentration registered 30 minutes before than the So2 one.}
#'   \item{Nox_0}{Nox air concentration registered 30 minutes before than the Nox one.}
#'   \item{So2_1}{So2 air concentration registered 45 minutes before than the So2 one.}
#'   \item{Nox_1}{Nox air concentration registered 45 minutes before than the Nox one.}
#'   \item{So2_2}{So2 air concentration registered 60 minutes before than the So2 one.}
#'   \item{Nox_2}{Nox air concentration registered 60 minutes before than the Nox one.}
#'   \item{So2_3}{So2 air concentration registered 75 minutes before than the So2 one.}
#'   \item{Nox_3}{Nox air concentration registered 75 minutes before than the Nox one.}
#'   \item{So2_4}{So2 air concentration registered 90 minutes before than the So2 one.}
#'   \item{Nox_4}{Nox air concentration registered 90 minutes before than the Nox one.}
#' }
#' @references Roca--Pardinas, J., Ordonez, C., & Lado Baleato, O. (2021). Nonparametric location scale model for the joint forecasting of SO2 and NOx pollution episodes. Stochastic Environmental Research and Risk Assessment, 35(2), 231--244.
"pollution"
