\name{plot.peer}
\alias{plot.peer}
\title{Plotting of estimated regression functions obtained through \code{peer()}}
\description{
Plots the estimate of components of estimated regression function obtained from a \code{\link{peer}} object along with pointwise confidence bands.
}
\usage{
\method{plot}{peer}(x, conf=0.95, ylab='Estimated regression function', main=expression(gamma), ...)
}
\arguments{
\item{x}{object of class \code{"\link{peer}"}.}
\item{conf}{pointwise confidence level.}
\item{ylab}{y-axis label.}
\item{main}{title for the plot.}
\item{...}{additional arguments passed to \code{\link{plot}}.}
}

\details{
Pointwise confidence interval is displayed only if the user set \code{se=T} in the call to \code{\link{peer}}, and does not reflect any multiplicity correction. 
}

\author{Madan Gopal Kundu \email{mgkundu@iupui.edu}}

\references{
Kundu, M. G., Harezlak, J., and Randolph, T. W. (2012). Longitudinal functional models with structured penalties. (Please contact J. Harezlak at \email{harezlak@iupui.edu}.)

Randolph, T. W., Harezlak, J, and Feng, Z. (2012). Structured penalties for functional linear models - partially empirical eigenvectors for regression. \emph{Electronic Journal of Statistics}, 6, 323--353.
}

\seealso{
\code{peer}, \code{lpeer}, \code{plot.lpeer}
}

\examples{
data(DTI)
cca = DTI$cca[which(DTI$case == 1),]
DTI = DTI[which(DTI$case == 1),]
fit.cca.peer1 = peer(Y=DTI$pasat, funcs = cca)
plot(fit.cca.peer1)
}
