% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_document_values.R
\name{get_document_values}
\alias{get_document_values}
\title{get_document_values}
\usage{
get_document_values(
  series,
  jurisdiction,
  year,
  document_type = 1,
  summary = FALSE,
  date_is_range = TRUE,
  country = FALSE,
  agency = NULL,
  cluster = NULL,
  label = NULL,
  industry = NULL,
  filtered = TRUE,
  label_level = 3,
  industry_level = NULL,
  label_source = "NAICS",
  version = NULL,
  download = FALSE,
  page = NULL,
  date = NULL,
  verbose = 0
)
}
\arguments{
\item{series}{Series ID (s)}

\item{jurisdiction}{ID for the jurisdiction}

\item{year}{Year(s) of data}

\item{document_type}{ID for type of document, default value of 1}

\item{summary}{Return summary instead of document level data
(only one year of data is allowed for document level data),
default value is FALSE here}

\item{date_is_range}{Indicating whether the time parameter is range or should
be treated as single data points, default value is TRUE}

\item{country}{Get values for all subjurisdictions, default value is FALSE}

\item{agency}{Agency ID, default value is NULL}

\item{cluster}{Cluster ID}

\item{label}{Industry code using the jurisdiction-specific coding system
(returns all 3-digit industries by default),
default value is NULL}

\item{industry}{industry is deprecated; use label}

\item{filtered}{Exclude poorly-performing industry results
(use of unfiltered results is NOT recommended),
default value is TRUE}

\item{label_level}{Level of NAICS industries to include, default value is 3}

\item{industry_level}{industryLevel is deprecated; use labellevel}

\item{label_source}{classification standard (NAICS, BEA, SOC),
default value of "NAICS"}

\item{version}{Version ID for datasets with multiple versions
(if no ID is given, returns most recent version),
default value is NULL}

\item{download}{If not False, a path location for a downloaded csv of the
results, default value is FALSE}

\item{page}{Page Number of the Response, default value is NULL}

\item{date}{date is deprecated, use year now}

\item{verbose}{Print out the url of the API call (useful for debugging),
default value is 0}
}
\value{
Returns pandas dataframe with the metadata
}
\description{
Get values for a specific jurisdiction and series at the document level
}
\examples{
\dontrun{get_document_values(
  series = 33, jurisdiction = 38,
  year = 2018, label = "111"
)}
}
