% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_model.R
\name{print.block_glm_summary}
\alias{print.block_glm_summary}
\title{Summarizing block general linear models.}
\usage{
\method{print}{block_glm_summary}(x, digits = max(3L, getOption("digits") -
  3L), signif.stars = getOption("show.signif.stars"), ...)
}
\arguments{
\item{x}{An object of class "\code{block_glm_summary}", usually, a result
of a call to \code{\link{summary.block_glm}}.}

\item{digits}{The number of significant digits to use when printing.}

\item{signif.stars}{Logical. If \code{TRUE}, 'significance stars' are printed
for each coefficient.}

\item{...}{Further arguments passed to or from other methods.}
}
\description{
\code{print} method for class "\code{block_glm_summary}".
}
\examples{
# 2 blocks: Petal.Length; Petal.Length + Petal.Width
model1 <- build_model(Sepal.Length, Petal.Length, Petal.Width, data=iris, model='lm')
summary(model1)
coef(model1)

# 2 blocks: Species; Species + Petal.Length + Petal.Width + Petal.Length:Petal.Width
model2 <- build_model(Sepal.Length, Species, c(Petal.Length * Petal.Width), data=iris, model='lm')
summary(model2)
coef(model2)
}
\seealso{
\code{\link{build_model}}, \code{\link{summary.block_glm}}
}

