# Generated by roxytest: Do not edit by hand!

# File R/REGModel.R: @testexamples

test_that("Function REGModel() @ L79", {
  
  library(survival)
  test1 <- data.frame(
    time = c(4, 3, 1, 1, 2, 2, 3),
    status = c(1, 1, 1, 0, 1, 1, 0),
    x = c(0, 2, 1, 1, 1, 0, 0),
    sex = c(0, 0, 0, 0, 1, 1, 1)
  )
  test1$sex <- factor(test1$sex)
  
  # --------------
  # Build a model
  # --------------
  
  # way 1:
  mm <- REGModel$new(
    test1,
    Surv(time, status) ~ x + strata(sex)
  )
  mm
  as.data.frame(mm$result)
  if (require("see")) mm$plot()
  mm$print() # Same as print(mm)
  
  # way 2:
  mm2 <- REGModel$new(
    test1,
    recipe = list(
      x = c("x", "strata(sex)"),
      y = c("time", "status")
    )
  )
  mm2
  
  # Add other parameters, e.g., weights
  # For more, see ?coxph
  mm3 <- REGModel$new(
    test1,
    recipe = list(
      x = c("x", "strata(sex)"),
      y = c("time", "status")
    ),
    weights = c(1, 1, 1, 2, 2, 2, 3)
  )
  mm3$args
  
  # ----------------------
  # Another type of model
  # ----------------------
  library(stats)
  counts <- c(18, 17, 15, 20, 10, 20, 25, 13, 12)
  outcome <- gl(3, 1, 9)
  treatment <- gl(3, 3)
  data <- data.frame(treatment, outcome, counts)
  
  mm4 <- REGModel$new(
    data,
    counts ~ outcome + treatment,
    f = "poisson"
  )
  mm4
  mm4$plot_forest()
  mm4$get_forest_data()
  mm4$plot_forest()
  expect_is(mm, "REGModel")
  expect_is(mm2, "REGModel")
  expect_equal(data.frame(mm$result), data.frame(mm2$result))
  expect_is(mm3, "REGModel")
  expect_is(mm4, "REGModel")
})

