\name{rsbplot}
\alias{rsbplot}
\title{Plot Rsb over a genome}
\description{Plot Rsb over a genome.}
\usage{rsbplot(data,plot.pval = TRUE,ylim.scan = 2,pch = 16,cex = 0.5,cex.lab = 1.25,
main = NA,cex.main = 1.5,cex.axis=1.)}

\arguments{
  \item{data}{A dataframe obtained using \code{ies2rsb} function.}
  \item{plot.pval}{Either TRUE or FALSE if Pvalue should not be plotted}
  \item{ylim.scan}{An horizontal line is added at the corresponding coordinate, for instance to represent a significance threshold}
  \item{pch}{Type of the points representing SNPs in the plot(s)}
  \item{cex}{Size of the points representing SNPs in the plot(s)}
  \item{cex.lab}{Size of axis legends}
  \item{main}{Main Legend of the plot}
  \item{cex.main}{Size of the main legend}
  \item{cex.axis}{Size of the axis annotations}
}
\value{The function returns a plot}
\references{
   Gautier, M. and Naves, M. (2011). Footprints of selection in the ancestral admixture of a New World
   Creole cattle breed. \emph{Molecular Ecology}, \bold{20}, 3128--3143.
   
   Tang, K. and Thornton, K.R. and Stoneking, M. (2007). A New Approach for Using Genome Scans
   to Detect Recent Positive Selection in the Human Genome. \emph{Plos Biology}, \bold{7}, e171.
}
\seealso{ies2rsb}
\examples{
data(wgscan.cgu) ; data(wgscan.eut) 
## results from a genome scan (44,057 SNPs)
#see ?wgscan.eut and ?wgscan.cgu for details
res.rsb<-ies2rsb(wgscan.cgu,wgscan.eut,"CGU","EUT")
rsbplot(res.rsb)
}
