% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomChild.R
\name{randomChild}
\alias{randomChild}
\title{Generate a random child from a given DNA profile and a given set of allele
frequencies}
\usage{
randomChild(profile, Freqs)
}
\arguments{
\item{profile}{A vector of length 2*nLoci. Each entry in the vector is the
(coded) allele held by the individual. This represents the parent. The
relationship is reflexive so it does not matter if the profile is a parent
or a child.}

\item{Freqs}{A list containing two lists labelled loci and freqs. The second
list is a list of vectors containing the allele frequencies of each allele
at each locus in the multiplex.}
}
\value{
A vector with 2*nLoci elements. Each pair of elements represents the
genotpe of the random individual at that locus. The genotype alleles are
always ordered so that allele1 <= allele2.
}
\description{
Generates a random child (or parent) from a given DNA profile from a given
set of allele frequencies. At each locus, the child inherits the first
allele of the given profile with one half, or the second allele with
probability one half. The second allele is chosen at random with probability
proportional to the allele frequencies.
}
\details{
The alleles are simply integers rather than the STR repeat numbers. This
speeds up computation immensely when calculating any of the LRs or IBS.
}
\examples{

data(fbiCaucs)
P1 = randomProfile(fbiCaucs)
C1 = randomChild(P1,fbiCaucs)
P1
C1

}
\seealso{
randomChild, randomSample, randomSib
}
\author{
James M. Curran
}
