library(remix)
remix(data = iris)
remix(cbind(...) ~ ., iris[, sapply(iris, is.numeric)], funs = c(median, mad, min, max))
remix(cbind(Sepal.Length, I(Sepal.Width^2)) ~ Species, iris, funs = quantile, probs = c(1/3, 2/3))
remix(cbind(Sepal.Length, I(Sepal.Width^2)) ~ Species, iris, funs = quantile, probs = c(1/3, 2/3), revert = TRUE)
remix(Sepal.Length + Sepal.Width ~ Petal.Length + Petal.Width, iris)
remix(cbind(Sepal.Length, Sepal.Width) ~ cbind(Petal.Length, Petal.Width), iris)
remix(cbind(Sepal.Length, Sepal.Width) ~ cbind(Petal.Length, Petal.Width) | Species, iris)
remix(... ~ ., esoph, cum = TRUE)
remix(alcgp ~ tobgp, esoph, cum = TRUE)
remix(agegp ~ . | alcgp + tobgp, esoph)
remix(agegp ~ . | alcgp:tobgp, esoph)
