% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_duplicates.R
\name{extract_duplicates}
\alias{extract_duplicates}
\title{Extract all duplicates}
\usage{
extract_duplicates(data, id)
}
\arguments{
\item{data}{The data frame.}

\item{id}{The ID variable for which to check for duplicates.}
}
\value{
A dataframe, containing all duplicates.
}
\description{
Extract all duplicates, for visual inspection.
Note that it also contains the first occurrence of future
duplicates, unlike \code{\link[=duplicated]{duplicated()}} or \code{\link[dplyr:distinct]{dplyr::distinct()}}). Also
contains an additional column reporting the number of missing
values for that row, to help in the decision-making when
selecting which duplicates to keep.
}
\examples{
df1 <- data.frame(
   id = c(1, 2, 3, 1, 3),
   item1 = c(NA, 1, 1, 2, 3),
   item2 = c(NA, 1, 1, 2, 3),
   item3 = c(NA, 1, 1, 2, 3)
)

extract_duplicates(df1, id = "id")

# Filter to exclude duplicates
df2 <- df1[-c(1, 5),]
df2

}
\keyword{duplicates}
