% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copyToFrom.R
\name{replyr_copy_to}
\alias{replyr_copy_to}
\title{Copy data to remote service.}
\usage{
replyr_copy_to(dest, df, name = deparse(substitute(df)), ...,
  rowNumberColumn = NULL, temporary = FALSE, overwrite = TRUE,
  maxrow = 1e+06, forceDelete = FALSE)
}
\arguments{
\item{dest}{remote data source}

\item{df}{local data frame}

\item{name}{name for new remote table}

\item{...}{force later values to be bound by name}

\item{rowNumberColumn}{if not null name to add row numbers to}

\item{temporary}{logical, if TRUE try to create a temporary table}

\item{overwrite}{logical, if TRUE try to overwrite}

\item{maxrow}{max rows to allow in a remote to remote copy.}

\item{forceDelete}{logical, if TRUE try to delete table.}
}
\value{
remote handle
}
\description{
Copy data to remote service.
}
\examples{


if (requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- dplyr::src_sqlite(":memory:", create = TRUE)
  d <- replyr_copy_to(my_db, data.frame(x=c(1,2)), 'd')
  print(d)
}

}
